/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.util.CbStrings;
import java.util.Objects;

public class NetworkResolution {
    public static final NetworkResolution DEFAULT = new NetworkResolution("default");
    public static final NetworkResolution AUTO = new NetworkResolution("auto");
    public static final NetworkResolution EXTERNAL = new NetworkResolution("external");
    private final String name;

    public static NetworkResolution valueOf(String name) {
        return CbStrings.isNullOrEmpty(name) ? AUTO : new NetworkResolution(name);
    }

    private NetworkResolution(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkResolution that = (NetworkResolution)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return this.name();
    }
}

