/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.eventing;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponseStatus;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.error.BucketNotFoundException;
import com.couchbase.client.core.error.CollectionNotFoundException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.EventingFunctionCompilationFailureException;
import com.couchbase.client.core.error.EventingFunctionDeployedException;
import com.couchbase.client.core.error.EventingFunctionIdenticalKeyspaceException;
import com.couchbase.client.core.error.EventingFunctionNotBootstrappedException;
import com.couchbase.client.core.error.EventingFunctionNotDeployedException;
import com.couchbase.client.core.error.EventingFunctionNotFoundException;
import com.couchbase.client.core.error.ScopeNotFoundException;
import com.couchbase.client.core.error.context.EventingErrorContext;
import com.couchbase.client.core.io.netty.HttpProtocol;
import com.couchbase.client.core.io.netty.NonChunkedHttpMessageHandler;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.NonChunkedHttpRequest;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.service.ServiceType;
import java.util.Locale;
import java.util.Map;

public class NonChunkedEventingMessageHandler
extends NonChunkedHttpMessageHandler {
    public NonChunkedEventingMessageHandler(BaseEndpoint endpoint) {
        super(endpoint, ServiceType.EVENTING);
    }

    @Override
    protected Exception failRequestWith(HttpResponseStatus status, String content, NonChunkedHttpRequest<Response> request) {
        Map<String, Object> properties = NonChunkedEventingMessageHandler.extractProperties(content);
        EventingErrorContext errorContext = new EventingErrorContext(HttpProtocol.decodeStatus(status), request.context(), status.code(), properties);
        if (content != null) {
            if (content.contains("ERR_APP_NOT_FOUND_TS")) {
                return new EventingFunctionNotFoundException("Eventing function not found", errorContext);
            }
            if (content.contains("ERR_APP_NOT_DEPLOYED")) {
                return new EventingFunctionNotDeployedException("Eventing function not deployed", errorContext);
            }
            if (content.contains("ERR_HANDLER_COMPILATION")) {
                return new EventingFunctionCompilationFailureException("Eventing function failed to compile", errorContext);
            }
            if (content.contains("ERR_COLLECTION_MISSING")) {
                return new CollectionNotFoundException("", errorContext);
            }
            if (content.contains("ERR_SRC_MB_SAME")) {
                return new EventingFunctionIdenticalKeyspaceException("The source keyspace and the metadata keyspace are the same", errorContext);
            }
            if (content.contains("ERR_APP_NOT_BOOTSTRAPPED")) {
                return new EventingFunctionNotBootstrappedException("Eventing function is not bootstrapped yet", errorContext);
            }
            if (content.contains("ERR_APP_NOT_UNDEPLOYED")) {
                return new EventingFunctionDeployedException("Eventing function deployed", errorContext);
            }
            if (content.contains("ERR_BUCKET_MISSING")) {
                if (content.toLowerCase(Locale.ROOT).contains("scope not defined")) {
                    return new ScopeNotFoundException("", errorContext);
                }
                return new BucketNotFoundException("", errorContext);
            }
        }
        return new CouchbaseException("Unknown eventing error: " + content, errorContext);
    }

    private static Map<String, Object> extractProperties(String content) {
        try {
            return Mapper.decodeInto(content, new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception ex) {
            return null;
        }
    }
}

