/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.util.Timeout;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

@Stability.Volatile
public class ProtostellarBaseRequest
implements Request<ProtostellarResponse> {
    private final ProtostellarRequest<?> request;
    private final CoreProtostellar core;

    @Stability.Internal
    public ProtostellarBaseRequest(CoreProtostellar core, ProtostellarRequest<?> request) {
        this.request = request;
        this.core = core;
    }

    private static UnsupportedOperationException unsupported(String message) {
        return new UnsupportedOperationException(message);
    }

    @Override
    public long id() {
        throw ProtostellarBaseRequest.unsupported("Protostellar requests do not have unique identifiers");
    }

    @Override
    public CompletableFuture<ProtostellarResponse> response() {
        throw ProtostellarBaseRequest.unsupported("Protostellar requests do not contain their responses");
    }

    @Override
    public void succeed(ProtostellarResponse result) {
        throw ProtostellarBaseRequest.unsupported("Protostellar requests cannot be succeeded this way");
    }

    @Override
    public void fail(Throwable error) {
        throw ProtostellarBaseRequest.unsupported("Protostellar requests cannot be failed this way");
    }

    @Override
    public void cancel(CancellationReason reason, Function<Throwable, Throwable> exceptionTranslator) {
        throw ProtostellarBaseRequest.unsupported("Protostellar requests cannot be cancelled this way");
    }

    @Override
    public void timeoutRegistration(Timeout registration) {
        throw ProtostellarBaseRequest.unsupported("Protostellar requests cannot have their timeouts configured in this way");
    }

    @Override
    public RequestContext context() {
        return new RequestContext(null, this.core.context().id(), this.core.context().environment(), this.core.context().authenticator(), this);
    }

    @Override
    public Duration timeout() {
        return this.request.timeout();
    }

    @Override
    public boolean timeoutElapsed() {
        return this.request.timeoutElapsed();
    }

    @Override
    public boolean completed() {
        return this.request.completed();
    }

    @Override
    public boolean succeeded() {
        return this.request.succeeded();
    }

    @Override
    public boolean failed() {
        return this.request.failed();
    }

    @Override
    public boolean cancelled() {
        return this.failed();
    }

    @Override
    public CancellationReason cancellationReason() {
        return this.request.cancellationReason();
    }

    @Override
    public ServiceType serviceType() {
        return this.request.serviceType();
    }

    @Override
    public Map<String, Object> serviceContext() {
        return CbCollections.mapOf();
    }

    @Override
    public RetryStrategy retryStrategy() {
        return this.request.retryStrategy();
    }

    @Override
    public RequestSpan requestSpan() {
        return this.request.span();
    }

    @Override
    public long createdAt() {
        return this.request.createdAt();
    }

    @Override
    public long absoluteTimeout() {
        return this.request.absoluteTimeout();
    }

    static class ProtostellarResponse
    implements Response {
        ProtostellarResponse() {
        }

        @Override
        public ResponseStatus status() {
            throw ProtostellarBaseRequest.unsupported("Protostellar requests do not have a status field");
        }
    }
}

