/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.search;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.manager.CoreBucketAndScope;
import com.couchbase.client.core.api.search.CoreSearchKeyset;
import com.couchbase.client.core.api.search.CoreSearchMetaData;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.api.search.CoreSearchOptions;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.CoreSearchScanConsistency;
import com.couchbase.client.core.api.search.facet.CoreDateRange;
import com.couchbase.client.core.api.search.facet.CoreDateRangeFacet;
import com.couchbase.client.core.api.search.facet.CoreNumericRange;
import com.couchbase.client.core.api.search.facet.CoreNumericRangeFacet;
import com.couchbase.client.core.api.search.facet.CoreSearchFacet;
import com.couchbase.client.core.api.search.facet.CoreTermFacet;
import com.couchbase.client.core.api.search.queries.CoreSearchRequest;
import com.couchbase.client.core.api.search.result.CoreDateRangeSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreNumericRangeSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreReactiveSearchResult;
import com.couchbase.client.core.api.search.result.CoreSearchDateRange;
import com.couchbase.client.core.api.search.result.CoreSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreSearchMetrics;
import com.couchbase.client.core.api.search.result.CoreSearchNumericRange;
import com.couchbase.client.core.api.search.result.CoreSearchResult;
import com.couchbase.client.core.api.search.result.CoreSearchRow;
import com.couchbase.client.core.api.search.result.CoreSearchRowLocation;
import com.couchbase.client.core.api.search.result.CoreSearchRowLocations;
import com.couchbase.client.core.api.search.result.CoreSearchTermRange;
import com.couchbase.client.core.api.search.result.CoreTermSearchFacetResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.google.protobuf.ByteString;
import com.couchbase.client.core.deps.com.google.protobuf.Timestamp;
import com.couchbase.client.core.deps.io.grpc.stub.StreamObserver;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.protostellar.CoreProtostellarAccessorsStreaming;
import com.couchbase.client.core.protostellar.CoreProtostellarErrorHandlingUtil;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.ProtostellarUtil;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.DateRange;
import com.couchbase.client.protostellar.search.v1.DateRangeFacet;
import com.couchbase.client.protostellar.search.v1.Facet;
import com.couchbase.client.protostellar.search.v1.NumericRange;
import com.couchbase.client.protostellar.search.v1.NumericRangeFacet;
import com.couchbase.client.protostellar.search.v1.SearchQueryRequest;
import com.couchbase.client.protostellar.search.v1.SearchQueryResponse;
import com.couchbase.client.protostellar.search.v1.SearchServiceGrpc;
import com.couchbase.client.protostellar.search.v1.TermFacet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ProtostellarCoreSearchOps
implements CoreSearchOps {
    private final CoreProtostellar core;
    @Nullable
    private final CoreBucketAndScope scope;

    public ProtostellarCoreSearchOps(CoreProtostellar core, @Nullable CoreBucketAndScope scope) {
        this.core = Objects.requireNonNull(core);
        this.scope = scope;
    }

    @Override
    public CoreAsyncResponse<CoreSearchResult> searchQueryAsync(String indexName, CoreSearchQuery search, CoreSearchOptions options) {
        ProtostellarRequest<SearchQueryRequest> request = ProtostellarCoreSearchOps.request(this.core, indexName, search, options, this.scope);
        CoreAsyncResponse responses = CoreProtostellarAccessorsStreaming.async(this.core, request, (endpoint, stream) -> ((SearchServiceGrpc.SearchServiceStub)endpoint.searchStub().withDeadline(request.deadline())).searchQuery((SearchQueryRequest)request.request(), (StreamObserver<SearchQueryResponse>)stream), error -> CoreProtostellarErrorHandlingUtil.convertException(this.core, request, error));
        return responses.map(results -> {
            ArrayList<CoreSearchRow> rows = new ArrayList<CoreSearchRow>();
            CoreSearchMetaData metaData = null;
            Map<String, CoreSearchFacetResult> facets = Collections.emptyMap();
            for (SearchQueryResponse r : results) {
                if (r.hasMetaData()) {
                    metaData = ProtostellarCoreSearchOps.parseMetadata(r);
                    facets = ProtostellarCoreSearchOps.parseFacets(r);
                }
                r.getHitsList().forEach(hit -> rows.add(ProtostellarCoreSearchOps.parse(hit)));
            }
            return new CoreSearchResult(rows, facets, metaData);
        });
    }

    private static CoreSearchMetaData parseMetadata(SearchQueryResponse response) {
        SearchQueryResponse.MetaData md = response.getMetaData();
        SearchQueryResponse.SearchMetrics metrics = md.getMetrics();
        return new CoreSearchMetaData(md.getErrorsMap(), new CoreSearchMetrics(ProtostellarUtil.convert(metrics.getExecutionTime()), metrics.getTotalRows(), metrics.getMaxScore(), metrics.getSuccessPartitionCount(), metrics.getErrorPartitionCount()));
    }

    @Override
    public Mono<CoreReactiveSearchResult> searchQueryReactive(String indexName, CoreSearchQuery query, CoreSearchOptions options) {
        return Mono.defer(() -> {
            try {
                ProtostellarRequest<SearchQueryRequest> request = ProtostellarCoreSearchOps.request(this.core, indexName, query, options, this.scope);
                Sinks.One out = Sinks.one();
                Flux responses = CoreProtostellarAccessorsStreaming.reactive(this.core, request, (endpoint, stream) -> ((SearchServiceGrpc.SearchServiceStub)endpoint.searchStub().withDeadline(request.deadline())).searchQuery((SearchQueryRequest)request.request(), (StreamObserver<SearchQueryResponse>)stream), error -> CoreProtostellarErrorHandlingUtil.convertException(this.core, request, error));
                Sinks.Many rows = Sinks.many().unicast().onBackpressureBuffer();
                Sinks.One metaData = Sinks.one();
                Sinks.One facets = Sinks.one();
                responses.publishOn(this.core.context().environment().scheduler()).subscribe(response -> {
                    response.getHitsList().forEach(hit -> {
                        CoreSearchRow row = ProtostellarCoreSearchOps.parse(hit);
                        rows.tryEmitNext(row).orThrow();
                    });
                    if (response.hasMetaData()) {
                        CoreSearchMetaData cmd = ProtostellarCoreSearchOps.parseMetadata(response);
                        metaData.tryEmitValue(cmd).orThrow();
                        if (response.getFacetsCount() > 0) {
                            Map<String, CoreSearchFacetResult> coreFacets = ProtostellarCoreSearchOps.parseFacets(response);
                            facets.tryEmitValue(coreFacets).orThrow();
                        } else {
                            facets.tryEmitValue(Collections.emptyMap()).orThrow();
                        }
                    }
                }, throwable -> rows.tryEmitError((Throwable)throwable).orThrow(), () -> rows.tryEmitComplete().orThrow());
                return Mono.just(new CoreReactiveSearchResult(rows.asFlux(), facets.asMono(), metaData.asMono()));
            }
            catch (Throwable err) {
                return Mono.error(err);
            }
        });
    }

    @Override
    public CoreAsyncResponse<CoreSearchResult> searchAsync(String indexName, CoreSearchRequest searchRequest, CoreSearchOptions options) {
        if (searchRequest.vectorSearch != null) {
            throw new FeatureNotAvailableException("Vector search is not currently available in couchbase2://");
        }
        return this.searchQueryAsync(indexName, searchRequest.searchQuery, options);
    }

    @Override
    public Mono<CoreReactiveSearchResult> searchReactive(String indexName, CoreSearchRequest searchRequest, CoreSearchOptions options) {
        if (searchRequest.vectorSearch != null) {
            throw new FeatureNotAvailableException("Vector search is not currently available in couchbase2://");
        }
        return this.searchQueryReactive(indexName, searchRequest.searchQuery, options);
    }

    private static Map<String, CoreSearchFacetResult> parseFacets(SearchQueryResponse response) {
        return CbCollections.transformValues(response.getFacetsMap(), ProtostellarCoreSearchOps::convertFacetResult);
    }

    private static CoreSearchFacetResult convertFacetResult(String facetName, SearchQueryResponse.FacetResult facet) {
        if (facet.hasTermFacet()) {
            SearchQueryResponse.TermFacetResult result = facet.getTermFacet();
            return new CoreTermSearchFacetResult(facetName, result.getField(), result.getTotal(), result.getMissing(), result.getOther(), CbCollections.transform(result.getTermsList(), it -> new CoreSearchTermRange(it.getName(), it.getSize())));
        }
        if (facet.hasNumericRangeFacet()) {
            SearchQueryResponse.NumericRangeFacetResult result = facet.getNumericRangeFacet();
            return new CoreNumericRangeSearchFacetResult(facetName, result.getField(), result.getTotal(), result.getMissing(), result.getOther(), CbCollections.transform(result.getNumericRangesList(), it -> new CoreSearchNumericRange(it.getName(), ProtostellarCoreSearchOps.parseNumericRangeEndpoint(it.getMin()), ProtostellarCoreSearchOps.parseNumericRangeEndpoint(it.getMax()), it.getSize())));
        }
        if (facet.hasDateRangeFacet()) {
            SearchQueryResponse.DateRangeFacetResult result = facet.getDateRangeFacet();
            return new CoreDateRangeSearchFacetResult(facetName, result.getField(), result.getTotal(), result.getMissing(), result.getOther(), CbCollections.transform(result.getDateRangesList(), it -> new CoreSearchDateRange(it.getName(), it.hasStart() ? ProtostellarCoreSearchOps.toInstant(it.getStart()) : null, it.hasEnd() ? ProtostellarCoreSearchOps.toInstant(it.getEnd()) : null, it.getSize())));
        }
        throw new RuntimeException("Unexpected facet result type: " + facet);
    }

    private static Double parseNumericRangeEndpoint(@Nullable Number n) {
        return n == null ? null : Double.valueOf(n.doubleValue());
    }

    private static CoreSearchRow parse(SearchQueryResponse.SearchQueryRow row) {
        return new CoreSearchRow(row.getIndex(), row.getId(), row.getScore(), row.getExplanation().toByteArray(), ProtostellarCoreSearchOps.parseLocations(row), ProtostellarCoreSearchOps.parseFragments(row), ProtostellarCoreSearchOps.parseFields(row), () -> CoreSearchKeyset.EMPTY);
    }

    private static byte[] parseFields(SearchQueryResponse.SearchQueryRow hit) {
        Map<String, ByteString> fields = hit.getFieldsMap();
        if (fields.isEmpty()) {
            return new byte[]{123, 125};
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(123);
        hit.getFieldsMap().forEach((key, value) -> {
            try {
                Mapper.writer().writeValue(os, key);
                os.write(58);
                os.write(value.toByteArray());
                os.write(44);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        byte[] result = os.toByteArray();
        result[result.length - 1] = 125;
        return result;
    }

    private static Map<String, List<String>> parseFragments(SearchQueryResponse.SearchQueryRow row) {
        return CbCollections.transformValues(row.getFragmentsMap(), SearchQueryResponse.Fragment::getContentList);
    }

    private static Optional<CoreSearchRowLocations> parseLocations(SearchQueryResponse.SearchQueryRow row) {
        if (row.getLocationsCount() == 0) {
            return Optional.empty();
        }
        ArrayList<CoreSearchRowLocation> result = new ArrayList<CoreSearchRowLocation>(row.getLocationsCount());
        row.getLocationsList().forEach(loc -> result.add(ProtostellarCoreSearchOps.parseOneLocation(loc)));
        return Optional.of(CoreSearchRowLocations.from(result));
    }

    private static CoreSearchRowLocation parseOneLocation(SearchQueryResponse.Location loc) {
        return new CoreSearchRowLocation(loc.getField(), loc.getTerm(), loc.getPosition(), loc.getStart(), loc.getEnd(), loc.getArrayPositionsCount() == 0 ? null : ProtostellarCoreSearchOps.toPrimitiveLongArray(loc.getArrayPositionsList()));
    }

    private static long[] toPrimitiveLongArray(List<? extends Number> list) {
        long[] result = new long[list.size()];
        ListIterator<? extends Number> i = list.listIterator();
        while (i.hasNext()) {
            result[i.nextIndex()] = i.next().longValue();
        }
        return result;
    }

    private static ProtostellarRequest<SearchQueryRequest> request(CoreProtostellar core, String indexName, CoreSearchQuery query, CoreSearchOptions opts, @Nullable CoreBucketAndScope scope) {
        Validators.notNull(indexName, "IndexName");
        Validators.notNull(query, "Query");
        Validators.notNull(opts, "SearchOptions");
        opts.validate();
        Duration timeout = opts.commonOptions().timeout().orElse(core.context().environment().timeoutConfig().queryTimeout());
        RequestSpan span = CoreProtostellarUtil.createSpan(core, "search", CoreDurability.NONE, opts.commonOptions().parentSpan().orElse(null));
        SearchQueryRequest.Builder request = SearchQueryRequest.newBuilder().setIndexName(indexName).setQuery(query.asProtostellar());
        if (scope != null) {
            request.setBucketName(scope.bucketName());
            request.setScopeName(scope.scopeName());
        }
        if (opts.consistency() != null && opts.consistency() == CoreSearchScanConsistency.NOT_BOUNDED) {
            request.setScanConsistency(SearchQueryRequest.ScanConsistency.SCAN_CONSISTENCY_NOT_BOUNDED);
        }
        if (opts.limit() != null) {
            request.setLimit(opts.limit());
        }
        if (opts.skip() != null) {
            request.setSkip(opts.skip());
        }
        if (opts.searchBefore() != null || opts.searchAfter() != null) {
            throw CoreProtostellarUtil.unsupportedInProtostellar("keyset pagination with searchBefore/After");
        }
        if (opts.explain() != null) {
            request.setIncludeExplanation(opts.explain());
        }
        if (opts.highlightStyle() != null) {
            switch (opts.highlightStyle()) {
                case HTML: {
                    request.setHighlightStyle(SearchQueryRequest.HighlightStyle.HIGHLIGHT_STYLE_HTML);
                    break;
                }
                case ANSI: {
                    request.setHighlightStyle(SearchQueryRequest.HighlightStyle.HIGHLIGHT_STYLE_ANSI);
                    break;
                }
                case SERVER_DEFAULT: {
                    request.setHighlightStyle(SearchQueryRequest.HighlightStyle.HIGHLIGHT_STYLE_DEFAULT);
                }
            }
        }
        if (!opts.highlightFields().isEmpty()) {
            request.addAllHighlightFields(opts.highlightFields());
        }
        if (!opts.fields().isEmpty()) {
            request.addAllFields(opts.fields());
        }
        opts.sort().forEach(sort -> request.addSort(sort.asProtostellar()));
        if (opts.disableScoring() != null) {
            request.setDisableScoring(opts.disableScoring());
        }
        if (!opts.collections().isEmpty()) {
            request.addAllCollections(opts.collections());
        }
        if (opts.includeLocations() != null) {
            request.setIncludeExplanation(opts.includeLocations());
        }
        opts.facets().forEach((name, facet) -> request.putFacets((String)name, ProtostellarCoreSearchOps.convertFacet(facet)));
        return new ProtostellarRequest<SearchQueryRequest>(request.build(), core, ServiceType.SEARCH, "search", span, timeout, false, opts.commonOptions().retryStrategy().orElse(core.context().environment().retryStrategy()), opts.commonOptions().clientContext(), 0L, null);
    }

    private static Facet convertFacet(CoreSearchFacet facet) {
        if (facet instanceof CoreTermFacet) {
            return ProtostellarCoreSearchOps.convertTermFacet(facet);
        }
        if (facet instanceof CoreNumericRangeFacet) {
            return ProtostellarCoreSearchOps.convertNumericRangeFacet(facet);
        }
        if (facet instanceof CoreDateRangeFacet) {
            return ProtostellarCoreSearchOps.convertDateRangeFacet(facet);
        }
        throw new RuntimeException("Unexpected facet type: " + facet.getClass());
    }

    @NonNull
    private static Facet convertDateRangeFacet(CoreSearchFacet facet) {
        DateRangeFacet.Builder builder = DateRangeFacet.newBuilder().setField(facet.field());
        Integer size = facet.size();
        if (size != null) {
            builder.setSize(size);
        }
        List<CoreDateRange> coreRanges = ((CoreDateRangeFacet)facet).dateRanges();
        coreRanges.forEach(it -> builder.addDateRanges(ProtostellarCoreSearchOps.convertDateRange(it)));
        return Facet.newBuilder().setDateRangeFacet(builder).build();
    }

    @NonNull
    private static Facet convertNumericRangeFacet(CoreSearchFacet facet) {
        NumericRangeFacet.Builder builder = NumericRangeFacet.newBuilder().setField(facet.field());
        Integer size = facet.size();
        if (size != null) {
            builder.setSize(size);
        }
        List<CoreNumericRange> coreRanges = ((CoreNumericRangeFacet)facet).ranges();
        coreRanges.forEach(it -> builder.addNumericRanges(ProtostellarCoreSearchOps.convertNumericRange(it)));
        return Facet.newBuilder().setNumericRangeFacet(builder).build();
    }

    @NonNull
    private static Facet convertTermFacet(CoreSearchFacet facet) {
        TermFacet.Builder builder = TermFacet.newBuilder().setField(facet.field());
        Integer size = facet.size();
        if (size != null) {
            builder.setSize(size);
        }
        return Facet.newBuilder().setTermFacet(builder).build();
    }

    private static DateRange.Builder convertDateRange(CoreDateRange range) {
        String end;
        DateRange.Builder builder = DateRange.newBuilder().setName(range.name());
        String start = range.start();
        if (start != null) {
            builder.setStart(start);
        }
        if ((end = range.end()) != null) {
            builder.setEnd(end);
        }
        return builder;
    }

    private static NumericRange.Builder convertNumericRange(CoreNumericRange range) {
        Double max;
        NumericRange.Builder builder = NumericRange.newBuilder().setName(range.name());
        Double min = range.min();
        if (min != null) {
            builder.setMin(min.floatValue());
        }
        if ((max = range.max()) != null) {
            builder.setMax(max.floatValue());
        }
        return builder;
    }

    private static Instant toInstant(Timestamp ts) {
        return Instant.ofEpochSecond(ts.getSeconds(), ts.getNanos());
    }
}

