/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.endpoint.KeyValueEndpoint;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.service.EndpointSelectionStrategy;
import com.couchbase.client.core.service.KeyValueServiceConfig;
import com.couchbase.client.core.service.PooledService;
import com.couchbase.client.core.service.ServiceConfig;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.service.strategy.PartitionSelectionStrategy;
import java.util.Optional;

public class KeyValueService
extends PooledService {
    private static final EndpointSelectionStrategy STRATEGY = new PartitionSelectionStrategy();
    private final String hostname;
    private final int port;
    private final Optional<String> bucketName;
    private final Authenticator authenticator;

    public KeyValueService(ServiceConfig serviceConfig, CoreContext coreContext, String hostname, int port, Optional<String> bucketName, Authenticator authenticator) {
        super(KeyValueService.inspectServiceConfig(serviceConfig, bucketName.isPresent()), new ServiceContext(coreContext, hostname, port, ServiceType.KV, bucketName));
        this.hostname = hostname;
        this.port = port;
        this.bucketName = bucketName;
        this.authenticator = authenticator;
    }

    private static ServiceConfig inspectServiceConfig(ServiceConfig original, boolean bucketPresent) {
        return bucketPresent ? original : KeyValueServiceConfig.endpoints(1).build();
    }

    @Override
    protected Endpoint createEndpoint() {
        return new KeyValueEndpoint(this.serviceContext(), this.hostname, this.port, this.bucketName, this.authenticator);
    }

    @Override
    protected EndpointSelectionStrategy selectionStrategy() {
        return STRATEGY;
    }

    @Override
    public ServiceType type() {
        return ServiceType.KV;
    }
}

