/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.diagnostics.EndpointDiagnostics;
import com.couchbase.client.core.diagnostics.InternalEndpointDiagnostics;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceState;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.core.util.Stateful;
import java.util.stream.Stream;

public interface Service
extends Stateful<ServiceState> {
    public void connect();

    public void disconnect();

    public <R extends Request<? extends Response>> void send(R var1);

    public ServiceContext context();

    public ServiceType type();

    public Stream<EndpointDiagnostics> diagnostics();

    default public HostAndPort address() {
        return new HostAndPort(this.context().remoteHostname(), this.context().remotePort());
    }

    @Stability.Internal
    public Stream<InternalEndpointDiagnostics> internalDiagnostics();
}

