/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.util.CbCollections;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class PartitionTopology {
    static final PartitionTopology ABSENT = new PartitionTopology(null, Collections.emptyList(), Collections.emptyList());
    private final Optional<HostAndServicePorts> active;
    private final List<HostAndServicePorts> availableReplicas;
    private final List<Integer> rawNodeIndexes;

    public PartitionTopology(@Nullable HostAndServicePorts active, List<HostAndServicePorts> availableReplicas, List<Integer> rawNodeIndexes) {
        this.active = Optional.ofNullable(active);
        this.availableReplicas = CbCollections.copyToUnmodifiableList(availableReplicas);
        this.rawNodeIndexes = CbCollections.copyToUnmodifiableList(rawNodeIndexes);
    }

    public static PartitionTopology parse(List<HostAndServicePorts> allNodes, List<Integer> partitionNodeIndexes) {
        int activeNodeIndex = partitionNodeIndexes.isEmpty() ? -2 : partitionNodeIndexes.get(0);
        HostAndServicePorts activeNode = activeNodeIndex < 0 ? null : allNodes.get(activeNodeIndex);
        return new PartitionTopology(activeNode, PartitionTopology.findAvailableReplicas(allNodes, partitionNodeIndexes), partitionNodeIndexes);
    }

    private static List<HostAndServicePorts> findAvailableReplicas(List<HostAndServicePorts> allNodes, List<Integer> nodeIndexes) {
        return nodeIndexes.stream().skip(1L).filter(nodeIndex -> nodeIndex >= 0).map(allNodes::get).collect(Collectors.toList());
    }

    public Optional<HostAndServicePorts> active() {
        return this.active;
    }

    public List<HostAndServicePorts> availableReplicas() {
        return this.availableReplicas;
    }

    public OptionalInt nodeIndexForActive() {
        return this.nodeIndex(0);
    }

    public OptionalInt nodeIndexForReplica(int replicaIndex) {
        return this.nodeIndex(replicaIndex + 1);
    }

    private OptionalInt nodeIndex(int activeOrReplica) {
        if (activeOrReplica < 0) {
            throw new IllegalArgumentException("activeOrReplica must be non-negative, but got " + activeOrReplica);
        }
        if (activeOrReplica >= this.rawNodeIndexes.size()) {
            return OptionalInt.empty();
        }
        int index = this.rawNodeIndexes.get(activeOrReplica);
        return index < 0 ? OptionalInt.empty() : OptionalInt.of(index);
    }

    List<Integer> rawNodeIndexes() {
        return this.rawNodeIndexes;
    }

    public String toString() {
        return this.rawNodeIndexes.stream().map(Object::toString).collect(Collectors.joining(",", "[", "]"));
    }
}

