/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

@Stability.Internal
public class TopologyHelper {
    private TopologyHelper() {
    }

    public static <V> LinkedHashMap<String, V> compressKeyRuns(Map<Integer, V> map) {
        SortedMap sorted = map instanceof SortedMap ? (SortedMap)map : new TreeMap<Integer, V>(map);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Integer runStart = null;
        Object runValue = null;
        Integer prevKey = null;
        for (Map.Entry entry : sorted.entrySet()) {
            Integer key = Objects.requireNonNull((Integer)entry.getKey(), "map had null key");
            Object value = entry.getValue();
            if (prevKey == null) {
                runStart = key;
                runValue = value;
                prevKey = key;
                continue;
            }
            if (Objects.equals(value, runValue) && key.equals(prevKey + 1)) {
                prevKey = key;
                continue;
            }
            result.put(TopologyHelper.closedIntRangeToString(runStart, prevKey), runValue);
            runStart = key;
            runValue = value;
            prevKey = key;
        }
        if (prevKey != null) {
            result.put(TopologyHelper.closedIntRangeToString(runStart, prevKey), runValue);
        }
        return result;
    }

    private static String closedIntRangeToString(int start, int end) {
        return start == end ? Integer.toString(start) : start + ".." + end;
    }
}

