/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.retry.reactor.Backoff;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.core.retry.reactor.RetryExhaustedException;
import java.time.Duration;
import reactor.core.publisher.Mono;

@Stability.Internal
public class BucketConfigUtil {
    private static final Duration retryDelay = Duration.ofMillis(100L);

    private BucketConfigUtil() {
    }

    public static Mono<BucketConfig> waitForBucketConfig(Core core, String bucketName, Duration timeout) {
        return Mono.fromCallable(() -> {
            BucketConfig bucketConfig = core.clusterConfig().bucketConfig(bucketName);
            if (bucketConfig == null) {
                throw new NullPointerException();
            }
            return bucketConfig;
        }).retryWhen(Retry.anyOf(NullPointerException.class).timeout(timeout).backoff(Backoff.fixed(retryDelay)).toReactorRetry()).onErrorResume(err -> {
            if (err instanceof RetryExhaustedException) {
                return Mono.error(new UnambiguousTimeoutException("Timed out while waiting for bucket config", null));
            }
            return Mono.error(err);
        });
    }
}

