/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.util.SingleStateful;
import com.couchbase.client.core.util.Stateful;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

public class CompositeStateful<T, IN, OUT>
implements Stateful<OUT> {
    private final OUT initialState;
    private final Map<T, IN> states;
    private final SingleStateful<OUT> inner;
    private final Map<T, Disposable> subscriptions;
    private final BiConsumer<OUT, OUT> beforeTransitionCallback;
    private final Function<Collection<IN>, OUT> transformer;

    private CompositeStateful(OUT initialState, Function<Collection<IN>, OUT> transformer, BiConsumer<OUT, OUT> beforeTransitionCallback) {
        this.inner = SingleStateful.fromInitial(initialState);
        this.initialState = initialState;
        this.transformer = transformer;
        this.subscriptions = new ConcurrentHashMap<T, Disposable>();
        this.states = new ConcurrentHashMap<T, IN>();
        this.beforeTransitionCallback = beforeTransitionCallback;
    }

    public static <T, IN, OUT> CompositeStateful<T, IN, OUT> create(OUT initialState, Function<Collection<IN>, OUT> transformer, BiConsumer<OUT, OUT> beforeTransitionCallback) {
        return new CompositeStateful<T, IN, OUT>(initialState, transformer, beforeTransitionCallback);
    }

    public static <T, IN, OUT> CompositeStateful<T, IN, OUT> create(OUT initialState, Function<Collection<IN>, OUT> transformer) {
        return CompositeStateful.create(initialState, transformer, (oldState, newState) -> {});
    }

    public synchronized void register(T identifier, Stateful<IN> upstream) {
        this.states.put(identifier, upstream.state());
        this.transition(this.transformer.apply(this.states.values()));
        Disposable subscription = upstream.states().subscribe(s -> {
            this.states.put(identifier, s);
            this.transition(this.transformer.apply(this.states.values()));
        }, e -> this.deregister(identifier), () -> this.deregister(identifier));
        this.subscriptions.put(identifier, subscription);
    }

    public synchronized void deregister(T identifier) {
        Disposable subscription = this.subscriptions.remove(identifier);
        if (subscription != null && !subscription.isDisposed()) {
            subscription.dispose();
            this.states.remove(identifier);
            this.transition(this.transformer.apply(this.states.values()));
        }
        if (this.subscriptions.isEmpty()) {
            this.transition(this.initialState);
        }
    }

    private void transition(OUT newState) {
        if (!this.inner.state().equals(newState)) {
            this.beforeTransitionCallback.accept(this.inner.state(), newState);
            this.inner.transition(newState);
        }
    }

    public synchronized void close() {
        HashSet<T> identifiers = new HashSet<T>(this.subscriptions.keySet());
        for (Object identifier : identifiers) {
            this.deregister(identifier);
        }
        this.inner.close();
    }

    @Override
    public OUT state() {
        return this.inner.state();
    }

    @Override
    public Flux<OUT> states() {
        return this.inner.states();
    }
}

