/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.org.xbill.DNS.ExtendedResolver;
import com.couchbase.client.core.deps.org.xbill.DNS.Name;
import com.couchbase.client.core.deps.org.xbill.DNS.ResolverConfig;
import com.couchbase.client.core.deps.org.xbill.DNS.SRVRecord;
import com.couchbase.client.core.deps.org.xbill.DNS.TextParseException;
import com.couchbase.client.core.deps.org.xbill.DNS.lookup.LookupSession;
import com.couchbase.client.core.deps.org.xbill.DNS.lookup.NoSuchDomainException;
import com.couchbase.client.core.util.HostAndPort;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.naming.NameNotFoundException;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class DnsSrvResolver {
    private final Executor executor;
    @Nullable
    private final String nameserver;

    public DnsSrvResolver(Executor executor) {
        this(executor, null);
    }

    DnsSrvResolver(Executor executor, @Nullable String nameserver) {
        this.executor = Objects.requireNonNull(executor);
        this.nameserver = nameserver;
        if (nameserver != null) {
            try {
                InetAddress.getByName(nameserver);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Invalid nameserver IP address: " + nameserver, e);
            }
        }
    }

    public Mono<List<HostAndPort>> resolve(String name) {
        Name parsedName = DnsSrvResolver.parseName(name);
        return Mono.defer(() -> {
            LookupSession session = this.newLookupSession();
            return Mono.fromFuture(session.lookupAsync(parsedName, 33).toCompletableFuture()).onErrorResume(t -> t instanceof NoSuchDomainException ? Mono.error(new NameNotFoundException(t.toString())) : Mono.error(t)).map(lookupResult -> lookupResult.getRecords().stream().map(record -> (SRVRecord)record).map(record -> new HostAndPort(record.getTarget().toString(true), record.getPort())).collect(Collectors.toList())).flatMap(it -> it.isEmpty() ? Mono.error(new NameNotFoundException("DNS SRV lookup was apparently successful, but returned no records.")) : Mono.just(it));
        });
    }

    private static Name parseName(String name) {
        try {
            return Name.fromString(name);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LookupSession newLookupSession() {
        try {
            Class<ResolverConfig> clazz = ResolverConfig.class;
            synchronized (ResolverConfig.class) {
                ResolverConfig.refresh();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return LookupSession.defaultBuilder().clearCaches().resolver(this.nameserver == null ? new ExtendedResolver() : new ExtendedResolver(new String[]{this.nameserver})).searchPath(ResolverConfig.getCurrentConfig().searchPath()).executor(this.executor).build();
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Bad nameserver IP address: " + this.nameserver, e);
        }
    }
}

