/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkRow;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkTrailer;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.analytics.AnalyticsResponse;
import com.couchbase.client.java.analytics.AnalyticsResult;
import com.couchbase.client.java.analytics.ReactiveAnalyticsResult;
import com.couchbase.client.java.codec.JsonSerializer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

public class AnalyticsAccessor {
    public static CompletableFuture<AnalyticsResult> analyticsQueryAsync(Core core, AnalyticsRequest request, JsonSerializer serializer) {
        return AnalyticsAccessor.analyticsQueryInternal(core, request).flatMap(response -> response.rows().collectList().flatMap(rows -> response.trailer().map(trailer -> new AnalyticsResult(response.header(), (List<AnalyticsChunkRow>)rows, (AnalyticsChunkTrailer)trailer, serializer)))).toFuture();
    }

    public static Mono<ReactiveAnalyticsResult> analyticsQueryReactive(Core core, AnalyticsRequest request, JsonSerializer serializer) {
        return AnalyticsAccessor.analyticsQueryInternal(core, request).map(r -> new ReactiveAnalyticsResult((AnalyticsResponse)r, serializer));
    }

    private static Mono<AnalyticsResponse> analyticsQueryInternal(Core core, AnalyticsRequest request) {
        core.send(request);
        return Reactor.wrap(request, request.response(), true).doOnNext(ignored -> request.context().logicallyComplete()).doOnError(err -> request.context().logicallyComplete((Throwable)err));
    }
}

