/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.codec;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.codec.TypeRef;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class LegacyTranscoder
implements Transcoder {
    private final JsonSerializer jsonSerializer;

    public static LegacyTranscoder create(JsonSerializer jsonSerializer) {
        return new LegacyTranscoder(jsonSerializer);
    }

    private LegacyTranscoder(JsonSerializer jsonSerializer) {
        this.jsonSerializer = Objects.requireNonNull(jsonSerializer);
    }

    @Override
    public Transcoder.EncodedValue encode(Object input) {
        if (input instanceof CommonOptions.BuiltCommonOptions || input instanceof CommonOptions) {
            throw InvalidArgumentException.fromMessage("No content provided, cannot encode " + input.getClass().getSimpleName() + " as content!");
        }
        if (input instanceof byte[]) {
            return new Transcoder.EncodedValue((byte[])input, CodecFlags.BINARY_COMPAT_FLAGS);
        }
        if (input instanceof String) {
            return new Transcoder.EncodedValue(((String)input).getBytes(StandardCharsets.UTF_8), CodecFlags.STRING_COMPAT_FLAGS);
        }
        return new Transcoder.EncodedValue(this.jsonSerializer.serialize(input), CodecFlags.JSON_COMPAT_FLAGS);
    }

    @Override
    public <T> T decode(Class<T> target, byte[] input, int flags) {
        if (target.equals(byte[].class)) {
            return (T)input;
        }
        if (target.equals(String.class)) {
            return (T)new String(input, StandardCharsets.UTF_8);
        }
        return this.jsonSerializer.deserialize(target, input);
    }

    @Override
    public <T> T decode(TypeRef<T> target, byte[] input, int flags) {
        return this.jsonSerializer.deserialize(target, input);
    }
}

