/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.Transcoder;
import java.nio.charset.StandardCharsets;

public class RawJsonTranscoder
implements Transcoder {
    public static RawJsonTranscoder INSTANCE = new RawJsonTranscoder();

    private RawJsonTranscoder() {
    }

    @Override
    public Transcoder.EncodedValue encode(Object input) {
        if (input instanceof CommonOptions.BuiltCommonOptions || input instanceof CommonOptions) {
            throw InvalidArgumentException.fromMessage("No content provided, cannot encode " + input.getClass().getSimpleName() + " as content!");
        }
        if (input instanceof byte[]) {
            return new Transcoder.EncodedValue((byte[])input, CodecFlags.JSON_COMPAT_FLAGS);
        }
        if (input instanceof String) {
            return new Transcoder.EncodedValue(((String)input).getBytes(StandardCharsets.UTF_8), CodecFlags.JSON_COMPAT_FLAGS);
        }
        throw InvalidArgumentException.fromMessage("Only byte[] and String types are supported for the RawJsonTranscoder!");
    }

    @Override
    public <T> T decode(Class<T> target, byte[] input, int flags) {
        if (target.equals(byte[].class)) {
            return (T)input;
        }
        if (target.equals(String.class)) {
            return (T)new String(input, StandardCharsets.UTF_8);
        }
        throw new DecodingFailureException("RawJsonTranscoder can only decode into either byte[] or String!");
    }
}

