/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.http;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpRequest;
import com.couchbase.client.core.error.HttpStatusCodeException;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.http.CommonHttpOptions;
import com.couchbase.client.java.http.HttpDeleteOptions;
import com.couchbase.client.java.http.HttpGetOptions;
import com.couchbase.client.java.http.HttpPath;
import com.couchbase.client.java.http.HttpPostOptions;
import com.couchbase.client.java.http.HttpPutOptions;
import com.couchbase.client.java.http.HttpResponse;
import com.couchbase.client.java.http.HttpTarget;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class AsyncCouchbaseHttpClient {
    private final AsyncCluster cluster;
    private final Core core;

    @Stability.Internal
    public AsyncCouchbaseHttpClient(AsyncCluster cluster) {
        this.cluster = Objects.requireNonNull(cluster);
        this.core = cluster.core();
    }

    public CompletableFuture<HttpResponse> get(HttpTarget target, HttpPath path) {
        return this.get(target, path, HttpGetOptions.httpGetOptions());
    }

    public CompletableFuture<HttpResponse> get(HttpTarget target, HttpPath path, HttpGetOptions options) {
        Validators.notNull(target, "target");
        Validators.notNull(path, "path");
        Validators.notNull(options, "options");
        HttpGetOptions.Built builtOpts = options.build();
        return this.exec(HttpMethod.GET, target, path, builtOpts, req -> {
            if (builtOpts.queryString() != null) {
                req.queryString(builtOpts.queryString().urlEncoded);
            }
        });
    }

    public CompletableFuture<HttpResponse> post(HttpTarget target, HttpPath path) {
        return this.post(target, path, HttpPostOptions.httpPostOptions());
    }

    public CompletableFuture<HttpResponse> post(HttpTarget target, HttpPath path, HttpPostOptions options) {
        Validators.notNull(target, "target");
        Validators.notNull(path, "path");
        Validators.notNull(options, "options");
        HttpPostOptions.Built builtOpts = options.build();
        return this.exec(HttpMethod.POST, target, path, builtOpts, req -> {
            if (builtOpts.body() != null) {
                req.content(builtOpts.body().content, builtOpts.body().contentType);
            }
        });
    }

    public CompletableFuture<HttpResponse> put(HttpTarget target, HttpPath path) {
        return this.put(target, path, HttpPutOptions.httpPutOptions());
    }

    public CompletableFuture<HttpResponse> put(HttpTarget target, HttpPath path, HttpPutOptions options) {
        Validators.notNull(target, "target");
        Validators.notNull(path, "path");
        Validators.notNull(options, "options");
        HttpPutOptions.Built builtOpts = options.build();
        return this.exec(HttpMethod.PUT, target, path, builtOpts, req -> {
            if (builtOpts.body() != null) {
                req.content(builtOpts.body().content, builtOpts.body().contentType);
            }
        });
    }

    public CompletableFuture<HttpResponse> delete(HttpTarget target, HttpPath path) {
        return this.delete(target, path, HttpDeleteOptions.httpDeleteOptions());
    }

    public CompletableFuture<HttpResponse> delete(HttpTarget target, HttpPath path, HttpDeleteOptions options) {
        Validators.notNull(target, "target");
        Validators.notNull(path, "path");
        Validators.notNull(options, "options");
        return this.exec(HttpMethod.DELETE, target, path, options.build(), req -> {});
    }

    private CompletableFuture<HttpResponse> exec(HttpMethod method, HttpTarget target, HttpPath path, CommonHttpOptions.BuiltCommonHttpOptions options, Consumer<CoreHttpRequest.Builder> customizer) {
        CoreHttpRequest.Builder builder = new CoreHttpClient(this.core, target.coreTarget).newRequest(method, CoreHttpPath.path(path.formatted), options).bypassExceptionTranslation(true);
        options.headers().forEach(it -> builder.header(it.name, it.value));
        customizer.accept(builder);
        CoreHttpRequest req = builder.build();
        if (req.bucket() != null) {
            this.cluster.bucket(req.bucket());
        }
        return ((CompletableFuture)req.exec(this.core).thenApply(HttpResponse::new)).exceptionally(t -> {
            HttpStatusCodeException statusCodeException = CbThrowables.findCause(t, HttpStatusCodeException.class).orElseThrow(() -> CbThrowables.propagate(t));
            return new HttpResponse(statusCodeException);
        });
    }
}

