/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.json;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectMapper;
import com.couchbase.client.core.deps.com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.RepackagedJsonValueModule;

@Stability.Internal
public class JacksonTransformers {
    public static final ObjectMapper MAPPER = new ObjectMapper();

    private JacksonTransformers() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static JsonObject stringToJsonObject(String input) throws Exception {
        return MAPPER.readValue(input, JsonObject.class);
    }

    public static JsonArray stringToJsonArray(String input) throws Exception {
        return MAPPER.readValue(input, JsonArray.class);
    }

    public static JsonArray bytesToJsonArray(byte[] input) throws Exception {
        return MAPPER.readValue(input, JsonArray.class);
    }

    public static JsonObject bytesToJsonObject(byte[] input) throws Exception {
        return MAPPER.readValue(input, JsonObject.class);
    }

    static {
        MAPPER.registerModule(new RepackagedJsonValueModule());
        MAPPER.registerModule(new AfterburnerModule());
    }
}

