/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.manager.CoreBucketManagerOps;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.CreateBucketOptions;
import com.couchbase.client.java.manager.bucket.DropBucketOptions;
import com.couchbase.client.java.manager.bucket.FlushBucketOptions;
import com.couchbase.client.java.manager.bucket.GetAllBucketOptions;
import com.couchbase.client.java.manager.bucket.GetBucketOptions;
import com.couchbase.client.java.manager.bucket.UpdateBucketOptions;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class AsyncBucketManager {
    private final CoreBucketManagerOps coreBucketManager;
    private final AsyncCluster cluster;
    private final boolean isProtostellar;

    @Stability.Internal
    public AsyncBucketManager(CoreCouchbaseOps ops, AsyncCluster cluster) {
        this.isProtostellar = ops instanceof CoreProtostellar;
        this.coreBucketManager = ops.bucketManager();
        this.cluster = Objects.requireNonNull(cluster);
    }

    public CompletableFuture<Void> createBucket(BucketSettings settings) {
        return this.createBucket(settings, CreateBucketOptions.createBucketOptions());
    }

    public CompletableFuture<Void> createBucket(BucketSettings settings, CreateBucketOptions options) {
        BucketSettings merged;
        if (this.isProtostellar) {
            merged = settings;
        } else {
            BucketSettings base = BucketSettings.createDefaults(settings.name());
            merged = BucketSettings.merge(base, settings);
        }
        return this.coreBucketManager.createBucket(merged.toCore(), options.build());
    }

    public CompletableFuture<Void> updateBucket(BucketSettings settings) {
        return this.updateBucket(settings, UpdateBucketOptions.updateBucketOptions());
    }

    public CompletableFuture<Void> updateBucket(BucketSettings settings, UpdateBucketOptions options) {
        return this.coreBucketManager.updateBucket(settings.toCore(), options.build());
    }

    public CompletableFuture<Void> dropBucket(String bucketName) {
        return this.dropBucket(bucketName, DropBucketOptions.dropBucketOptions());
    }

    public CompletableFuture<Void> dropBucket(String bucketName, DropBucketOptions options) {
        return this.coreBucketManager.dropBucket(bucketName, options.build());
    }

    public CompletableFuture<BucketSettings> getBucket(String bucketName) {
        return this.getBucket(bucketName, GetBucketOptions.getBucketOptions());
    }

    public CompletableFuture<BucketSettings> getBucket(String bucketName, GetBucketOptions options) {
        return this.coreBucketManager.getBucket(bucketName, options.build()).thenApply(BucketSettings::new);
    }

    public CompletableFuture<Map<String, BucketSettings>> getAllBuckets() {
        return this.getAllBuckets(GetAllBucketOptions.getAllBucketOptions());
    }

    public CompletableFuture<Map<String, BucketSettings>> getAllBuckets(GetAllBucketOptions options) {
        return this.coreBucketManager.getAllBuckets(options.build()).thenApply(buckets -> CbCollections.transformValues(buckets, BucketSettings::new));
    }

    public CompletableFuture<Void> flushBucket(String bucketName) {
        return this.flushBucket(bucketName, FlushBucketOptions.flushBucketOptions());
    }

    public CompletableFuture<Void> flushBucket(String bucketName, FlushBucketOptions options) {
        return this.coreBucketManager.flushBucket(bucketName, options.build());
    }
}

