/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.collection;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class CollectionSpec {
    @Stability.Volatile
    public static final Duration SAME_EXPIRY_AS_BUCKET = Duration.ZERO;
    @Stability.Volatile
    public static final Duration NEVER_EXPIRE = Duration.ofSeconds(-1L);
    private final String name;
    private final String scopeName;
    private final Duration maxExpiry;
    private final Boolean history;

    private CollectionSpec(String name, String scopeName, Duration maxExpiry, @Nullable Boolean history) {
        this.name = Validators.notNullOrEmpty(name, "Name");
        this.scopeName = Validators.notNullOrEmpty(scopeName, "Scope Name");
        this.maxExpiry = CollectionSpec.internExpiry(Validators.notNull(maxExpiry, "Max Expiry"));
        this.history = history;
    }

    private static Duration internExpiry(Duration d) {
        if (d.equals(SAME_EXPIRY_AS_BUCKET)) {
            return SAME_EXPIRY_AS_BUCKET;
        }
        if (d.equals(NEVER_EXPIRE)) {
            return NEVER_EXPIRE;
        }
        return d;
    }

    public static CollectionSpec create(String name) {
        return CollectionSpec.create(name, "_default");
    }

    public static CollectionSpec create(String name, String scopeName) {
        return new CollectionSpec(name, scopeName, SAME_EXPIRY_AS_BUCKET, null);
    }

    @Stability.Volatile
    public static CollectionSpec create(String name, Duration maxExpiry) {
        return CollectionSpec.create(name, "_default", maxExpiry);
    }

    @Stability.Volatile
    public static CollectionSpec create(String name, String scopeName, Duration maxExpiry) {
        return new CollectionSpec(name, scopeName, maxExpiry, null);
    }

    @Stability.Volatile
    @Stability.Internal
    protected static CollectionSpec internalCreate(String name, String scopeName, Duration maxExpiry, Boolean history) {
        return new CollectionSpec(name, scopeName, maxExpiry, history);
    }

    public String name() {
        return this.name;
    }

    public String scopeName() {
        return this.scopeName;
    }

    @Stability.Volatile
    public Duration maxExpiry() {
        return this.maxExpiry;
    }

    @Stability.Volatile
    public Boolean history() {
        return this.history;
    }

    public String toString() {
        return "CollectionSpec{name='" + RedactableArgument.redactMeta(this.name) + '\'' + ", scopeName='" + RedactableArgument.redactMeta(this.scopeName) + '\'' + ", maxExpiry=" + RedactableArgument.redactMeta(this.maxExpiry.getSeconds()) + ", history=" + RedactableArgument.redactMeta(this.history) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionSpec that = (CollectionSpec)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.scopeName, that.scopeName) && Objects.equals(this.maxExpiry, that.maxExpiry) && Objects.equals(this.history, that.history);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.scopeName, this.maxExpiry, this.history);
    }
}

