/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreBucketAndScope;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.manager.CoreEventingFunctionManager;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.java.manager.eventing.DeployFunctionOptions;
import com.couchbase.client.java.manager.eventing.DropFunctionOptions;
import com.couchbase.client.java.manager.eventing.EventingFunction;
import com.couchbase.client.java.manager.eventing.EventingStatus;
import com.couchbase.client.java.manager.eventing.FunctionsStatusOptions;
import com.couchbase.client.java.manager.eventing.GetAllFunctionsOptions;
import com.couchbase.client.java.manager.eventing.GetFunctionOptions;
import com.couchbase.client.java.manager.eventing.PauseFunctionOptions;
import com.couchbase.client.java.manager.eventing.ResumeFunctionOptions;
import com.couchbase.client.java.manager.eventing.UndeployFunctionOptions;
import com.couchbase.client.java.manager.eventing.UpsertFunctionOptions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import reactor.util.annotation.Nullable;

@Stability.Volatile
public class AsyncScopeEventingFunctionManager {
    private final CoreEventingFunctionManager coreManager;
    private final AsyncCluster cluster;

    @Stability.Internal
    public AsyncScopeEventingFunctionManager(Core core, AsyncCluster cluster, @Nullable CoreBucketAndScope scope) {
        this.coreManager = new CoreEventingFunctionManager(core, scope);
        this.cluster = Objects.requireNonNull(cluster);
    }

    public CompletableFuture<Void> upsertFunction(EventingFunction function) {
        return this.upsertFunction(function, UpsertFunctionOptions.upsertFunctionOptions());
    }

    public CompletableFuture<Void> upsertFunction(EventingFunction function, UpsertFunctionOptions options) {
        return this.coreManager.upsertFunction(function.name(), AsyncEventingFunctionManager.encodeFunction(function), options.build());
    }

    public CompletableFuture<EventingFunction> getFunction(String name) {
        return this.getFunction(name, GetFunctionOptions.getFunctionOptions());
    }

    public CompletableFuture<EventingFunction> getFunction(String name, GetFunctionOptions options) {
        return this.coreManager.getFunction(name, options.build()).thenApply(AsyncEventingFunctionManager::decodeFunction);
    }

    public CompletableFuture<List<EventingFunction>> getAllFunctions() {
        return this.getAllFunctions(GetAllFunctionsOptions.getAllFunctionsOptions());
    }

    public CompletableFuture<List<EventingFunction>> getAllFunctions(GetAllFunctionsOptions options) {
        return this.coreManager.getAllFunctions(options.build()).thenApply(AsyncEventingFunctionManager::decodeFunctions);
    }

    public CompletableFuture<Void> dropFunction(String name) {
        return this.dropFunction(name, DropFunctionOptions.dropFunctionOptions());
    }

    public CompletableFuture<Void> dropFunction(String name, DropFunctionOptions options) {
        return this.coreManager.dropFunction(name, options.build());
    }

    public CompletableFuture<Void> deployFunction(String name) {
        return this.deployFunction(name, DeployFunctionOptions.deployFunctionOptions());
    }

    public CompletableFuture<Void> deployFunction(String name, DeployFunctionOptions options) {
        return this.coreManager.deployFunction(name, options.build());
    }

    public CompletableFuture<Void> undeployFunction(String name) {
        return this.undeployFunction(name, UndeployFunctionOptions.undeployFunctionOptions());
    }

    public CompletableFuture<Void> undeployFunction(String name, UndeployFunctionOptions options) {
        return this.coreManager.undeployFunction(name, options.build());
    }

    public CompletableFuture<Void> pauseFunction(String name) {
        return this.pauseFunction(name, PauseFunctionOptions.pauseFunctionOptions());
    }

    public CompletableFuture<Void> pauseFunction(String name, PauseFunctionOptions options) {
        return this.coreManager.pauseFunction(name, options.build());
    }

    public CompletableFuture<Void> resumeFunction(String name) {
        return this.resumeFunction(name, ResumeFunctionOptions.resumeFunctionOptions());
    }

    public CompletableFuture<Void> resumeFunction(String name, ResumeFunctionOptions options) {
        return this.coreManager.resumeFunction(name, options.build());
    }

    public CompletableFuture<EventingStatus> functionsStatus() {
        return this.functionsStatus(FunctionsStatusOptions.functionsStatusOptions());
    }

    public CompletableFuture<EventingStatus> functionsStatus(FunctionsStatusOptions options) {
        return this.coreManager.functionsStatus(options.build()).thenApply(bytes -> Mapper.decodeInto(bytes, EventingStatus.class));
    }
}

