/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.Collection;

public class EventingFunctionKeyspace {
    private final String bucket;
    private final String scope;
    private final String collection;

    private EventingFunctionKeyspace(String bucket, String scope, String collection) {
        this.bucket = Validators.notNull(bucket, "bucket");
        this.scope = scope == null || scope.isEmpty() ? "_default" : scope;
        this.collection = collection == null || collection.isEmpty() ? "_default" : collection;
    }

    public static EventingFunctionKeyspace create(String bucket) {
        return new EventingFunctionKeyspace(bucket, null, null);
    }

    public static EventingFunctionKeyspace create(String bucket, String collection) {
        return new EventingFunctionKeyspace(bucket, null, collection);
    }

    public static EventingFunctionKeyspace create(String bucket, String scope, String collection) {
        return new EventingFunctionKeyspace(bucket, scope, collection);
    }

    public static EventingFunctionKeyspace create(Collection collection) {
        return new EventingFunctionKeyspace(collection.bucketName(), collection.scopeName(), collection.name());
    }

    public String bucket() {
        return this.bucket;
    }

    public String scope() {
        return this.scope;
    }

    public String collection() {
        return this.collection;
    }

    public String toString() {
        return "EventingFunctionKeyspace{bucket='" + this.bucket + '\'' + ", scope='" + this.scope + '\'' + ", collection='" + this.collection + '\'' + '}';
    }
}

