/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.manager.eventing.EventingFunctionUrlAuth;

public class EventingFunctionUrlBinding {
    private final String hostname;
    private final String alias;
    private final boolean allowCookies;
    private final boolean validateSslCertificate;
    private final EventingFunctionUrlAuth auth;

    public static EventingFunctionUrlBinding create(String hostname, String alias) {
        return EventingFunctionUrlBinding.builder(hostname, alias).build();
    }

    public static Builder builder(String hostname, String alias) {
        return new Builder(hostname, alias);
    }

    private EventingFunctionUrlBinding(Builder builder) {
        this.hostname = builder.hostname;
        this.alias = builder.alias;
        this.allowCookies = builder.allowCookies;
        this.validateSslCertificate = builder.validateSslCertificate;
        this.auth = builder.auth;
    }

    public String hostname() {
        return this.hostname;
    }

    public String alias() {
        return this.alias;
    }

    public boolean allowCookies() {
        return this.allowCookies;
    }

    public boolean validateSslCertificate() {
        return this.validateSslCertificate;
    }

    public EventingFunctionUrlAuth auth() {
        return this.auth;
    }

    public String toString() {
        return "EventingFunctionUrlBinding{hostname='" + RedactableArgument.redactMeta(this.hostname) + '\'' + ", alias='" + RedactableArgument.redactMeta(this.alias) + '\'' + ", allowCookies=" + this.allowCookies + ", validateSslCertificate=" + this.validateSslCertificate + ", auth=" + this.auth + '}';
    }

    public static class Builder {
        private final String hostname;
        private final String alias;
        private boolean allowCookies;
        private boolean validateSslCertificate;
        private EventingFunctionUrlAuth auth = EventingFunctionUrlAuth.noAuth();

        private Builder(String hostname, String alias) {
            this.hostname = Validators.notNullOrEmpty(hostname, "Hostname");
            this.alias = Validators.notNullOrEmpty(alias, "Alias");
        }

        public Builder allowCookies(boolean allowCookies) {
            this.allowCookies = allowCookies;
            return this;
        }

        public Builder validateSslCertificate(boolean validateSslCertificate) {
            this.validateSslCertificate = validateSslCertificate;
            return this;
        }

        public Builder auth(EventingFunctionUrlAuth auth) {
            this.auth = Validators.notNull(auth, "EventingFunctionUrlAuth");
            return this;
        }

        public EventingFunctionUrlBinding build() {
            return new EventingFunctionUrlBinding(this);
        }
    }
}

