/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreCreatePrimaryQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreScopeAndCollection;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CreatePrimaryQueryIndexOptions
extends CommonOptions<CreatePrimaryQueryIndexOptions> {
    private final Map<String, Object> with = new HashMap<String, Object>();
    private Optional<String> indexName = Optional.empty();
    private boolean ignoreIfExists;
    private String scopeName;
    private String collectionName;
    private Integer numReplicas;
    private Boolean deferred;

    private CreatePrimaryQueryIndexOptions() {
    }

    public static CreatePrimaryQueryIndexOptions createPrimaryQueryIndexOptions() {
        return new CreatePrimaryQueryIndexOptions();
    }

    public CreatePrimaryQueryIndexOptions indexName(String indexName) {
        this.indexName = Optional.ofNullable(CbStrings.emptyToNull(indexName));
        return this;
    }

    public CreatePrimaryQueryIndexOptions ignoreIfExists(boolean ignoreIfExists) {
        this.ignoreIfExists = ignoreIfExists;
        return this;
    }

    public CreatePrimaryQueryIndexOptions numReplicas(int numReplicas) {
        this.numReplicas = numReplicas;
        return this;
    }

    public CreatePrimaryQueryIndexOptions deferred(boolean deferred) {
        this.deferred = deferred;
        return this;
    }

    public CreatePrimaryQueryIndexOptions with(String optionName, Object optionValue) {
        this.with.put(Validators.notNullOrEmpty(optionName, "OptionName"), Validators.notNull(optionValue, "OptionValue"));
        return this;
    }

    @Deprecated
    public CreatePrimaryQueryIndexOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty(scopeName, "ScopeName");
        return this;
    }

    @Deprecated
    public CreatePrimaryQueryIndexOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty(collectionName, "CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage("If a collectionName is provided, a scopeName must also be provided");
        }
        if (this.scopeName != null && this.collectionName == null) {
            throw InvalidArgumentException.fromMessage("If a scopeName is provided, a collectionName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions
    implements CoreCreatePrimaryQueryIndexOptions {
        Built() {
        }

        @Override
        public boolean ignoreIfExists() {
            return CreatePrimaryQueryIndexOptions.this.ignoreIfExists;
        }

        @Override
        public Integer numReplicas() {
            return CreatePrimaryQueryIndexOptions.this.numReplicas;
        }

        @Override
        public Boolean deferred() {
            return CreatePrimaryQueryIndexOptions.this.deferred;
        }

        @Override
        public String indexName() {
            return CreatePrimaryQueryIndexOptions.this.indexName.orElse(null);
        }

        @Override
        public Map<String, Object> with() {
            return CreatePrimaryQueryIndexOptions.this.with;
        }

        @Override
        public CoreScopeAndCollection scopeAndCollection() {
            if (CreatePrimaryQueryIndexOptions.this.scopeName != null && CreatePrimaryQueryIndexOptions.this.collectionName != null) {
                return new CoreScopeAndCollection(CreatePrimaryQueryIndexOptions.this.scopeName, CreatePrimaryQueryIndexOptions.this.collectionName);
            }
            return null;
        }

        @Override
        public CoreCommonOptions commonOptions() {
            return this;
        }
    }
}

