/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreCreateQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreScopeAndCollection;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import java.util.HashMap;
import java.util.Map;

public class CreateQueryIndexOptions
extends CommonOptions<CreateQueryIndexOptions> {
    private final Map<String, Object> with = new HashMap<String, Object>();
    private boolean ignoreIfExists;
    private String scopeName;
    private String collectionName;
    private Integer numReplicas;
    private Boolean deferred;

    private CreateQueryIndexOptions() {
    }

    public static CreateQueryIndexOptions createQueryIndexOptions() {
        return new CreateQueryIndexOptions();
    }

    public CreateQueryIndexOptions ignoreIfExists(boolean ignoreIfExists) {
        this.ignoreIfExists = ignoreIfExists;
        return this;
    }

    public CreateQueryIndexOptions numReplicas(int numReplicas) {
        this.numReplicas = numReplicas;
        return this;
    }

    public CreateQueryIndexOptions deferred(boolean deferred) {
        this.deferred = deferred;
        return this;
    }

    public CreateQueryIndexOptions with(String optionName, Object optionValue) {
        this.with.put(Validators.notNullOrEmpty(optionName, "OptionName"), Validators.notNull(optionValue, "OptionValue"));
        return this;
    }

    @Deprecated
    public CreateQueryIndexOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty(scopeName, "ScopeName");
        return this;
    }

    @Deprecated
    public CreateQueryIndexOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty(collectionName, "CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage("If a collectionName is provided, a scopeName must also be provided");
        }
        if (this.scopeName != null && this.collectionName == null) {
            throw InvalidArgumentException.fromMessage("If a scopeName is provided, a collectionName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions
    implements CoreCreateQueryIndexOptions {
        Built() {
        }

        @Override
        public boolean ignoreIfExists() {
            return CreateQueryIndexOptions.this.ignoreIfExists;
        }

        @Override
        public Integer numReplicas() {
            return CreateQueryIndexOptions.this.numReplicas;
        }

        @Override
        public Boolean deferred() {
            return CreateQueryIndexOptions.this.deferred;
        }

        @Override
        public Map<String, Object> with() {
            return CreateQueryIndexOptions.this.with;
        }

        @Override
        public CoreScopeAndCollection scopeAndCollection() {
            if (CreateQueryIndexOptions.this.scopeName != null && CreateQueryIndexOptions.this.collectionName != null) {
                return new CoreScopeAndCollection(CreateQueryIndexOptions.this.scopeName, CreateQueryIndexOptions.this.collectionName);
            }
            return null;
        }

        @Override
        public CoreCommonOptions commonOptions() {
            return this;
        }
    }
}

