/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreDropQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreScopeAndCollection;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;

public class DropQueryIndexOptions
extends CommonOptions<DropQueryIndexOptions> {
    private boolean ignoreIfNotExists;
    private String scopeName;
    private String collectionName;

    private DropQueryIndexOptions() {
    }

    public static DropQueryIndexOptions dropQueryIndexOptions() {
        return new DropQueryIndexOptions();
    }

    public DropQueryIndexOptions ignoreIfNotExists(boolean ignore) {
        this.ignoreIfNotExists = ignore;
        return this;
    }

    @Deprecated
    public DropQueryIndexOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty(scopeName, "ScopeName");
        return this;
    }

    @Deprecated
    public DropQueryIndexOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty(collectionName, "CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage("If a collectionName is provided, a scopeName must also be provided");
        }
        if (this.scopeName != null && this.collectionName == null) {
            throw InvalidArgumentException.fromMessage("If a scopeName is provided, a collectionName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions
    implements CoreDropQueryIndexOptions {
        Built() {
        }

        @Override
        public boolean ignoreIfNotExists() {
            return DropQueryIndexOptions.this.ignoreIfNotExists;
        }

        @Override
        public CoreScopeAndCollection scopeAndCollection() {
            if (DropQueryIndexOptions.this.scopeName != null && DropQueryIndexOptions.this.collectionName != null) {
                return new CoreScopeAndCollection(DropQueryIndexOptions.this.scopeName, DropQueryIndexOptions.this.collectionName);
            }
            return null;
        }

        @Override
        public CoreCommonOptions commonOptions() {
            return this;
        }
    }
}

