/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreQueryIndex;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import java.util.Objects;
import java.util.Optional;

public class QueryIndex {
    private final CoreQueryIndex internal;

    @Stability.Internal
    QueryIndex(CoreQueryIndex internal) {
        this.internal = Objects.requireNonNull(internal);
    }

    public boolean primary() {
        return this.internal.primary();
    }

    public String name() {
        return this.internal.name();
    }

    public String type() {
        return this.internal.type();
    }

    public String state() {
        return this.internal.state();
    }

    public String keyspace() {
        return this.internal.keyspace();
    }

    public String namespace() {
        return this.internal.namespace();
    }

    public JsonArray indexKey() {
        return JsonArray.fromJson(this.internal.indexKey().toString());
    }

    public Optional<String> condition() {
        return this.internal.condition();
    }

    public Optional<String> partition() {
        return this.internal.partition();
    }

    public Optional<String> scopeName() {
        return this.internal.scopeName();
    }

    public String bucketName() {
        return this.internal.bucketName();
    }

    public Optional<String> collectionName() {
        return this.internal.collectionName();
    }

    public JsonObject raw() {
        return JsonObject.fromJson(this.internal.raw().toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryIndex that = (QueryIndex)o;
        return this.raw().equals(that.raw());
    }

    public int hashCode() {
        return Objects.hash(this.raw());
    }

    public String toString() {
        return RedactableArgument.redactMeta(this.raw()).toString();
    }
}

