/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.user;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.java.manager.user.AuthDomain;
import com.couchbase.client.java.manager.user.Role;
import com.couchbase.client.java.manager.user.RoleAndOrigins;
import com.couchbase.client.java.manager.user.User;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Stability.Volatile
@JsonIgnoreProperties(ignoreUnknown=true)
public class UserAndMetadata {
    private final AuthDomain domain;
    private final Optional<Instant> passwordChanged;
    private final String username;
    private final String displayName;
    private final Set<String> groups;
    private final Set<String> externalGroups;
    private final List<RoleAndOrigins> effectiveRoles;

    public UserAndMetadata(@JsonProperty(value="domain") AuthDomain domain, @JsonProperty(value="id") String username, @JsonProperty(value="name") String displayName, @JsonProperty(value="roles") Collection<RoleAndOrigins> effectiveRoles, @JsonProperty(value="groups") Collection<String> groups, @JsonProperty(value="external_groups") Collection<String> externalGroups, @JsonProperty(value="password_change_date") String passwordChanged) {
        this.username = Objects.requireNonNull(username);
        this.displayName = CbStrings.nullToEmpty(displayName);
        this.groups = CbCollections.copyToUnmodifiableSet(groups);
        this.domain = Objects.requireNonNull(domain);
        this.effectiveRoles = CbCollections.copyToUnmodifiableList(effectiveRoles);
        this.passwordChanged = UserAndMetadata.parseOptionalInstant(passwordChanged);
        this.externalGroups = CbCollections.copyToUnmodifiableSet(externalGroups);
    }

    public AuthDomain domain() {
        return this.domain;
    }

    public User user() {
        return new User(this.username).displayName(this.displayName).groups(this.groups).roles(this.innateRoles());
    }

    public Set<Role> innateRoles() {
        return this.effectiveRoles.stream().filter(RoleAndOrigins::innate).map(RoleAndOrigins::role).collect(Collectors.toSet());
    }

    public Set<Role> effectiveRoles() {
        return this.effectiveRoles.stream().map(RoleAndOrigins::role).collect(Collectors.toSet());
    }

    public List<RoleAndOrigins> effectiveRolesAndOrigins() {
        return this.effectiveRoles;
    }

    public Set<String> externalGroups() {
        return this.externalGroups;
    }

    public Optional<Instant> passwordChanged() {
        return this.passwordChanged;
    }

    private static Optional<Instant> parseOptionalInstant(String passwordChanged) {
        return CbStrings.isNullOrEmpty(passwordChanged) ? Optional.empty() : Optional.of(Instant.parse(passwordChanged));
    }

    public String toString() {
        return "UserAndMetadata{domain=" + (Object)((Object)this.domain) + ", user=" + this.user() + ", passwordChanged=" + this.passwordChanged + ", externalGroups=" + this.externalGroups + ", effectiveRoles=" + this.effectiveRoles + '}';
    }
}

