/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.annotation.UsedBy;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryProfile;
import com.couchbase.client.core.api.query.CoreQueryScanConsistency;
import com.couchbase.client.core.api.shared.CoreMutationState;
import com.couchbase.client.core.classic.query.ClassicCoreQueryOps;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.transaction.config.CoreSingleQueryTransactionOptions;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.MutationState;
import com.couchbase.client.java.query.QueryOptionsUtil;
import com.couchbase.client.java.query.QueryProfile;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.transactions.config.SingleQueryTransactionOptions;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public class QueryOptions
extends CommonOptions<QueryOptions> {
    private boolean adhoc = true;
    private String clientContextId;
    private MutationState consistentWith;
    private Integer maxParallelism;
    private boolean metrics = false;
    private JsonObject namedParameters;
    private Integer pipelineBatch;
    private Integer pipelineCap;
    private JsonArray positionalParameters;
    private CoreQueryProfile profile;
    private Map<String, Object> raw;
    private boolean readonly = false;
    private Duration scanWait;
    private Integer scanCap;
    private CoreQueryScanConsistency scanConsistency;
    private JsonSerializer serializer;
    private boolean flexIndex = false;
    private Boolean preserveExpiry = null;
    private boolean asTransaction = false;
    private CoreSingleQueryTransactionOptions asTransactionOptions;
    private Boolean useReplica = null;

    protected QueryOptions() {
    }

    public static QueryOptions queryOptions() {
        return new QueryOptions();
    }

    public QueryOptions raw(String key, Object value) {
        Validators.notNullOrEmpty(key, "Key");
        if (this.raw == null) {
            this.raw = new HashMap<String, Object>();
        }
        this.raw.put(key, value);
        return this;
    }

    public QueryOptions adhoc(boolean adhoc) {
        this.adhoc = adhoc;
        return this;
    }

    public QueryOptions scanConsistency(QueryScanConsistency scanConsistency) {
        Validators.notNull(scanConsistency, "QueryScanConsistency");
        switch (scanConsistency) {
            case NOT_BOUNDED: {
                this.scanConsistency = CoreQueryScanConsistency.NOT_BOUNDED;
                break;
            }
            case REQUEST_PLUS: {
                this.scanConsistency = CoreQueryScanConsistency.REQUEST_PLUS;
                break;
            }
            default: {
                throw new InvalidArgumentException("Unknown scan consistency type " + (Object)((Object)scanConsistency), null, null);
            }
        }
        this.consistentWith = null;
        return this;
    }

    public QueryOptions serializer(JsonSerializer serializer) {
        Validators.notNull(serializer, "JsonSerializer");
        this.serializer = serializer;
        return this;
    }

    public QueryOptions profile(QueryProfile profile) {
        Validators.notNull(profile, "QueryProfile");
        switch (profile) {
            case OFF: {
                this.profile = CoreQueryProfile.OFF;
                break;
            }
            case PHASES: {
                this.profile = CoreQueryProfile.PHASES;
                break;
            }
            case TIMINGS: {
                this.profile = CoreQueryProfile.TIMINGS;
                break;
            }
            default: {
                throw new InvalidArgumentException("Unknown profile type " + (Object)((Object)profile), null, null);
            }
        }
        return this;
    }

    public QueryOptions clientContextId(String clientContextId) {
        this.clientContextId = clientContextId == null || clientContextId.isEmpty() ? null : clientContextId;
        return this;
    }

    public QueryOptions metrics(boolean metrics) {
        this.metrics = metrics;
        return this;
    }

    public QueryOptions scanWait(Duration wait) {
        Validators.notNull(wait, "Wait Duration");
        this.scanWait = this.scanConsistency != null && this.scanConsistency == CoreQueryScanConsistency.NOT_BOUNDED ? null : wait;
        return this;
    }

    public QueryOptions maxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
        return this;
    }

    public QueryOptions readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public QueryOptions scanCap(int scanCap) {
        this.scanCap = scanCap;
        return this;
    }

    public QueryOptions pipelineBatch(int pipelineBatch) {
        this.pipelineBatch = pipelineBatch;
        return this;
    }

    public QueryOptions pipelineCap(int pipelineCap) {
        this.pipelineCap = pipelineCap;
        return this;
    }

    public QueryOptions parameters(JsonObject named) {
        Validators.notNull(named, "Named Parameters");
        this.namedParameters = named;
        this.positionalParameters = null;
        return this;
    }

    public QueryOptions parameters(JsonArray positional) {
        Validators.notNull(positional, "Positional Parameters");
        this.positionalParameters = positional;
        this.namedParameters = null;
        return this;
    }

    public QueryOptions consistentWith(MutationState mutationState) {
        Validators.notNull(mutationState, "MutationState");
        this.consistentWith = mutationState;
        this.scanConsistency = null;
        return this;
    }

    public QueryOptions flexIndex(boolean flexIndex) {
        this.flexIndex = flexIndex;
        return this;
    }

    public QueryOptions preserveExpiry(boolean preserveExpiry) {
        this.preserveExpiry = preserveExpiry;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public QueryOptions asTransaction() {
        this.asTransaction = true;
        return this;
    }

    public QueryOptions asTransaction(SingleQueryTransactionOptions options) {
        Validators.notNull(options, "asTransaction");
        this.asTransaction = true;
        this.asTransactionOptions = options.build();
        return this;
    }

    public QueryOptions useReplica(@Nullable Boolean useReplica) {
        this.useReplica = useReplica;
        return this;
    }

    @Stability.Internal
    public class Built
    extends CommonOptions.BuiltCommonOptions
    implements CoreQueryOptions {
        private final CoreCommonOptions common = CoreCommonOptions.ofOptional(this.timeout(), this.retryStrategy(), this.parentSpan());

        Built() {
        }

        @Override
        public boolean readonly() {
            return QueryOptions.this.readonly;
        }

        @Override
        public Duration scanWait() {
            return QueryOptions.this.scanWait;
        }

        @Override
        public Integer scanCap() {
            return QueryOptions.this.scanCap;
        }

        @Override
        public CoreQueryScanConsistency scanConsistency() {
            return QueryOptions.this.scanConsistency;
        }

        @Override
        public boolean flexIndex() {
            return QueryOptions.this.flexIndex;
        }

        @Override
        public Boolean preserveExpiry() {
            return QueryOptions.this.preserveExpiry;
        }

        public JsonSerializer serializer() {
            return QueryOptions.this.serializer;
        }

        @Override
        public boolean adhoc() {
            return QueryOptions.this.adhoc;
        }

        @Override
        public String clientContextId() {
            return QueryOptions.this.clientContextId;
        }

        @Override
        public CoreMutationState consistentWith() {
            if (QueryOptions.this.consistentWith == null) {
                return null;
            }
            return new CoreMutationState(QueryOptions.this.consistentWith);
        }

        @Override
        public Integer maxParallelism() {
            return QueryOptions.this.maxParallelism;
        }

        @Override
        public boolean metrics() {
            return QueryOptions.this.metrics;
        }

        @Override
        public ObjectNode namedParameters() {
            if (QueryOptions.this.namedParameters == null) {
                return null;
            }
            try {
                return (ObjectNode)Mapper.reader().readTree(QueryOptions.this.namedParameters.toString());
            }
            catch (JsonProcessingException e) {
                throw new InvalidArgumentException("Unable to convert named parameters", e, null);
            }
        }

        @Override
        public Integer pipelineBatch() {
            return QueryOptions.this.pipelineBatch;
        }

        @Override
        public Integer pipelineCap() {
            return QueryOptions.this.pipelineCap;
        }

        @Override
        public ArrayNode positionalParameters() {
            if (QueryOptions.this.positionalParameters == null) {
                return null;
            }
            try {
                return (ArrayNode)Mapper.reader().readTree(QueryOptions.this.positionalParameters.toString());
            }
            catch (JsonProcessingException e) {
                throw new InvalidArgumentException("Unable to convert named parameters", e, null);
            }
        }

        @Override
        public CoreQueryProfile profile() {
            return QueryOptions.this.profile;
        }

        @Override
        public JsonNode raw() {
            if (QueryOptions.this.raw == null) {
                return null;
            }
            return QueryOptionsUtil.convert(QueryOptions.this.raw);
        }

        @Stability.Internal
        @UsedBy(value=UsedBy.Project.SPRING_DATA_COUCHBASE)
        public void injectParams(JsonObject queryJson) {
            ObjectNode params = ClassicCoreQueryOps.convertOptions(this);
            Map map = Mapper.convertValue((Object)params, Map.class);
            map.forEach(queryJson::put);
        }

        @Override
        public boolean asTransaction() {
            return QueryOptions.this.asTransaction;
        }

        @Override
        public CoreSingleQueryTransactionOptions asTransactionOptions() {
            return QueryOptions.this.asTransactionOptions;
        }

        @Override
        public CoreCommonOptions commonOptions() {
            return this.common;
        }

        @Override
        public Boolean useReplica() {
            return QueryOptions.this.useReplica;
        }
    }
}

