/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreDateRangeQuery;
import com.couchbase.client.java.search.SearchQuery;
import java.time.Instant;

public class DateRangeQuery
extends SearchQuery {
    private String start;
    private String end;
    private Boolean inclusiveStart = null;
    private Boolean inclusiveEnd = null;
    private String dateTimeParser;
    private String field;

    public DateRangeQuery start(String start, boolean inclusive) {
        this.start = start;
        this.inclusiveStart = inclusive;
        return this;
    }

    public DateRangeQuery start(String start) {
        this.start = start;
        this.inclusiveStart = null;
        return this;
    }

    public DateRangeQuery end(String end, boolean inclusive) {
        this.end = end;
        this.inclusiveEnd = inclusive;
        return this;
    }

    public DateRangeQuery end(String end) {
        this.end = end;
        this.inclusiveEnd = null;
        return this;
    }

    public DateRangeQuery start(Instant start, boolean inclusive) {
        this.start = start.toString();
        this.inclusiveStart = inclusive;
        return this;
    }

    public DateRangeQuery start(Instant start) {
        this.start = start.toString();
        this.inclusiveStart = null;
        return this;
    }

    public DateRangeQuery end(Instant end, boolean inclusive) {
        this.end = end.toString();
        this.inclusiveEnd = inclusive;
        return this;
    }

    public DateRangeQuery end(Instant end) {
        this.end = end.toString();
        this.inclusiveEnd = null;
        return this;
    }

    public DateRangeQuery dateTimeParser(String dateTimeParser) {
        this.dateTimeParser = dateTimeParser;
        return this;
    }

    public DateRangeQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public DateRangeQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    public CoreSearchQuery toCore() {
        return new CoreDateRangeQuery(this.start, this.end, this.inclusiveStart, this.inclusiveEnd, this.dateTimeParser, this.field, this.boost);
    }
}

