/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.query;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.classic.query.PreparedStatementStrategy;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.query.PreparedStatement;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.query.QueryResponse;
import reactor.core.publisher.Mono;

@Stability.Internal
public class LegacyPreparedStatementStrategy
extends PreparedStatementStrategy {
    public LegacyPreparedStatementStrategy(Core core, int cacheSize) {
        super(core, cacheSize);
    }

    @Override
    public Mono<QueryResponse> execute(QueryRequest request) {
        return Mono.fromCallable(() -> (PreparedStatement)this.cache.get(request.statement())).switchIfEmpty(this.prepare(request)).flatMap(preparedStatement -> this.executeAlreadyPrepared(request, (PreparedStatement)preparedStatement));
    }

    private Mono<PreparedStatement> prepare(QueryRequest originalRequest) {
        return this.executeAdhoc(originalRequest.toPrepareRequest(false, this.requestTracer())).flatMap(queryResponse -> queryResponse.rows().next()).flatMap(row -> {
            ObjectNode node = (ObjectNode)Mapper.decodeIntoTree(row.data());
            PreparedStatement prepared = PreparedStatement.legacy(node.get("name").textValue(), node.get("encoded_plan").textValue());
            this.cache.put(originalRequest.statement(), prepared);
            return Mono.just(prepared);
        });
    }
}

