/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.tracing.OrphanRecordDroppedEvent;
import com.couchbase.client.core.cnc.events.tracing.OrphanReporterFailureDetectedEvent;
import com.couchbase.client.core.cnc.events.tracing.OrphansRecordedEvent;
import com.couchbase.client.core.deps.org.jctools.queues.MpscArrayQueue;
import com.couchbase.client.core.env.OrphanReporterConfig;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.UnmonitoredRequest;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.view.ViewRequest;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.core.util.NanoTimestamp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Mono;

@Stability.Internal
public class OrphanReporter {
    public static final String ORPHAN_TREAD_PREFIX = "cb-orphan-";
    private static final AtomicInteger ORPHAN_REPORTER_ID = new AtomicInteger();
    private static final String KEY_TOTAL_MICROS = "total_duration_us";
    private static final String KEY_DISPATCH_MICROS = "last_dispatch_duration_us";
    private static final String KEY_TOTAL_DISPATCH_MICROS = "total_dispatch_duration_us";
    private static final String KEY_ENCODE_MICROS = "encode_duration_us";
    private static final String KEY_SERVER_MICROS = "last_server_duration_us";
    private static final String KEY_TOTAL_SERVER_MICROS = "total_server_duration_us";
    private static final String KEY_OPERATION_ID = "operation_id";
    private static final String KEY_OPERATION_NAME = "operation_name";
    private static final String KEY_LAST_LOCAL_SOCKET = "last_local_socket";
    private static final String KEY_LAST_REMOTE_SOCKET = "last_remote_socket";
    private static final String KEY_LAST_LOCAL_ID = "last_local_id";
    private static final String KEY_TIMEOUT = "timeout_ms";
    private final AtomicBoolean running = new AtomicBoolean(false);
    volatile Thread worker = null;
    private final Queue<Request<?>> orphanQueue;
    private final Duration emitInterval;
    private final int sampleSize;
    private final EventBus eventBus;
    private final boolean enabled;
    private final OrphanReporterConfig config;

    @Stability.Internal
    public OrphanReporter(EventBus eventBus, OrphanReporterConfig config) {
        this.eventBus = eventBus;
        this.orphanQueue = new MpscArrayQueue(config.queueLength());
        this.emitInterval = config.emitInterval();
        this.sampleSize = config.sampleSize();
        this.enabled = config.enabled();
        this.config = config;
        if (this.enabled) {
            this.worker = new Thread(new Worker());
            this.worker.setDaemon(true);
            this.worker.setName(ORPHAN_TREAD_PREFIX + ORPHAN_REPORTER_ID.incrementAndGet());
        }
    }

    public OrphanReporterConfig config() {
        return this.config;
    }

    public Mono<Void> start() {
        return Mono.defer(() -> {
            if (this.enabled && this.running.compareAndSet(false, true)) {
                this.worker.start();
            }
            return Mono.empty();
        });
    }

    public Mono<Void> stop() {
        return Mono.defer(() -> {
            if (this.enabled && this.running.compareAndSet(true, false)) {
                this.worker.interrupt();
            }
            return Mono.empty();
        });
    }

    public void report(Request<?> request) {
        if (!this.enabled || request instanceof UnmonitoredRequest) {
            return;
        }
        if (!this.orphanQueue.offer(request)) {
            this.eventBus.publish(new OrphanRecordDroppedEvent(request.getClass()));
        }
    }

    private class Worker
    implements Runnable {
        private final long workerSleepMs = Long.parseLong(System.getProperty("com.couchbase.orphanReporterSleep", "100"));
        private final boolean newOutputFormat = Boolean.parseBoolean(System.getProperty("com.couchbase.orphanReporterNewOutputFormat", "true"));
        private final Comparator<Request<?>> THRESHOLD_COMPARATOR = Comparator.comparingLong(o -> o.context().logicalRequestLatency());
        private NanoTimestamp lastThresholdLog = NanoTimestamp.never();
        private boolean hasThresholdWritten;
        private final Queue<Request<?>> kvOrphans = new PriorityQueue(this.THRESHOLD_COMPARATOR);
        private final Queue<Request<?>> queryOrphans = new PriorityQueue(this.THRESHOLD_COMPARATOR);
        private final Queue<Request<?>> viewOrphans = new PriorityQueue(this.THRESHOLD_COMPARATOR);
        private final Queue<Request<?>> searchOrphans = new PriorityQueue(this.THRESHOLD_COMPARATOR);
        private final Queue<Request<?>> analyticsOrphans = new PriorityQueue(this.THRESHOLD_COMPARATOR);
        private long kvOrphanCount = 0L;
        private long queryOrphanCount = 0L;
        private long viewOrphanCount = 0L;
        private long searchOrphanCount = 0L;
        private long analyticsOrphanCount = 0L;

        private Worker() {
        }

        @Override
        public void run() {
            while (OrphanReporter.this.running.get()) {
                try {
                    this.handleOrphanQueue();
                    Thread.sleep(this.workerSleepMs);
                }
                catch (InterruptedException ex) {
                    if (OrphanReporter.this.running.get()) continue;
                    return;
                }
                catch (Exception ex) {
                    OrphanReporter.this.eventBus.publish(new OrphanReporterFailureDetectedEvent(ex));
                }
            }
        }

        private void handleOrphanQueue() {
            if (this.lastThresholdLog.hasElapsed(OrphanReporter.this.emitInterval)) {
                if (this.newOutputFormat) {
                    this.prepareAndLogOrphansNew();
                } else {
                    this.prepareAndLogOrphansOld();
                }
                this.lastThresholdLog = NanoTimestamp.now();
            }
            Request request;
            while ((request = (Request)OrphanReporter.this.orphanQueue.poll()) != null) {
                ServiceType serviceType = request.serviceType();
                if (serviceType == ServiceType.KV) {
                    this.updateSet(this.kvOrphans, request);
                    ++this.kvOrphanCount;
                    continue;
                }
                if (serviceType == ServiceType.QUERY) {
                    this.updateSet(this.queryOrphans, request);
                    ++this.queryOrphanCount;
                    continue;
                }
                if (serviceType == ServiceType.VIEWS) {
                    this.updateSet(this.viewOrphans, request);
                    ++this.viewOrphanCount;
                    continue;
                }
                if (serviceType == ServiceType.SEARCH) {
                    this.updateSet(this.searchOrphans, request);
                    ++this.searchOrphanCount;
                    continue;
                }
                if (serviceType != ServiceType.ANALYTICS) continue;
                this.updateSet(this.analyticsOrphans, request);
                ++this.analyticsOrphanCount;
            }
            return;
        }

        private void updateSet(Queue<Request<?>> set, Request<?> request) {
            set.add(request);
            while (set.size() > OrphanReporter.this.sampleSize) {
                set.remove();
            }
            this.hasThresholdWritten = true;
        }

        private void prepareAndLogOrphansNew() {
            if (!this.hasThresholdWritten) {
                return;
            }
            this.hasThresholdWritten = false;
            HashMap<String, Object> output = new HashMap<String, Object>();
            if (!this.kvOrphans.isEmpty()) {
                output.put("kv", this.convertOrphanMetadataNew(this.kvOrphans, this.kvOrphanCount));
                this.kvOrphans.clear();
                this.kvOrphanCount = 0L;
            }
            if (!this.queryOrphans.isEmpty()) {
                output.put("query", this.convertOrphanMetadataNew(this.queryOrphans, this.queryOrphanCount));
                this.queryOrphans.clear();
                this.queryOrphanCount = 0L;
            }
            if (!this.viewOrphans.isEmpty()) {
                output.put("views", this.convertOrphanMetadataNew(this.viewOrphans, this.viewOrphanCount));
                this.viewOrphans.clear();
                this.viewOrphanCount = 0L;
            }
            if (!this.searchOrphans.isEmpty()) {
                output.put("search", this.convertOrphanMetadataNew(this.searchOrphans, this.searchOrphanCount));
                this.searchOrphans.clear();
                this.searchOrphanCount = 0L;
            }
            if (!this.analyticsOrphans.isEmpty()) {
                output.put("analytics", this.convertOrphanMetadataNew(this.analyticsOrphans, this.analyticsOrphanCount));
                this.analyticsOrphans.clear();
                this.analyticsOrphanCount = 0L;
            }
            this.logOrphans(output, null);
        }

        private void prepareAndLogOrphansOld() {
            if (!this.hasThresholdWritten) {
                return;
            }
            this.hasThresholdWritten = false;
            ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
            if (!this.kvOrphans.isEmpty()) {
                output.add(this.convertOrphanMetadataOld(this.kvOrphans, this.kvOrphanCount, "kv"));
                this.kvOrphans.clear();
                this.kvOrphanCount = 0L;
            }
            if (!this.queryOrphans.isEmpty()) {
                output.add(this.convertOrphanMetadataOld(this.queryOrphans, this.queryOrphanCount, "query"));
                this.queryOrphans.clear();
                this.queryOrphanCount = 0L;
            }
            if (!this.viewOrphans.isEmpty()) {
                output.add(this.convertOrphanMetadataOld(this.viewOrphans, this.viewOrphanCount, "views"));
                this.viewOrphans.clear();
                this.viewOrphanCount = 0L;
            }
            if (!this.searchOrphans.isEmpty()) {
                output.add(this.convertOrphanMetadataOld(this.searchOrphans, this.searchOrphanCount, "search"));
                this.searchOrphans.clear();
                this.searchOrphanCount = 0L;
            }
            if (!this.analyticsOrphans.isEmpty()) {
                output.add(this.convertOrphanMetadataOld(this.analyticsOrphans, this.analyticsOrphanCount, "analytics"));
                this.analyticsOrphans.clear();
                this.analyticsOrphanCount = 0L;
            }
            this.logOrphans(null, output);
        }

        private Map<String, Object> convertOrphanMetadataNew(Queue<Request<?>> requests, long count) {
            HashMap<String, Object> output = new HashMap<String, Object>();
            ArrayList top = new ArrayList();
            for (Request request : requests) {
                HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                if (request != null) {
                    long totalServerDuration;
                    long serverDuration;
                    long totalDispatchDuration;
                    long dispatchDuration;
                    long encodeDuration;
                    String localId;
                    fieldMap.put(OrphanReporter.KEY_TOTAL_MICROS, TimeUnit.NANOSECONDS.toMicros(request.context().logicalRequestLatency()));
                    fieldMap.put(OrphanReporter.KEY_OPERATION_NAME, request.name());
                    String operationId = request.operationId();
                    if (operationId != null) {
                        fieldMap.put(OrphanReporter.KEY_OPERATION_ID, operationId);
                    }
                    if ((localId = request.context().lastChannelId()) != null) {
                        fieldMap.put(OrphanReporter.KEY_LAST_LOCAL_ID, RedactableArgument.redactSystem(localId));
                    }
                    if ((encodeDuration = request.context().encodeLatency()) > 0L) {
                        fieldMap.put(OrphanReporter.KEY_ENCODE_MICROS, TimeUnit.NANOSECONDS.toMicros(encodeDuration));
                    }
                    if ((dispatchDuration = request.context().dispatchLatency()) > 0L) {
                        fieldMap.put(OrphanReporter.KEY_DISPATCH_MICROS, TimeUnit.NANOSECONDS.toMicros(dispatchDuration));
                    }
                    if ((totalDispatchDuration = request.context().totalDispatchLatency()) > 0L) {
                        fieldMap.put(OrphanReporter.KEY_TOTAL_DISPATCH_MICROS, TimeUnit.NANOSECONDS.toMicros(totalDispatchDuration));
                    }
                    HostAndPort local = request.context().lastDispatchedFrom();
                    HostAndPort peer = request.context().lastDispatchedTo();
                    if (local != null) {
                        fieldMap.put(OrphanReporter.KEY_LAST_LOCAL_SOCKET, RedactableArgument.redactSystem(local.toString()));
                    }
                    if (peer != null) {
                        fieldMap.put(OrphanReporter.KEY_LAST_REMOTE_SOCKET, RedactableArgument.redactSystem(peer.toString()));
                    }
                    if ((serverDuration = request.context().serverLatency()) > 0L) {
                        fieldMap.put(OrphanReporter.KEY_SERVER_MICROS, serverDuration);
                    }
                    if ((totalServerDuration = request.context().totalServerLatency()) > 0L) {
                        fieldMap.put(OrphanReporter.KEY_TOTAL_SERVER_MICROS, totalServerDuration);
                    }
                    fieldMap.put(OrphanReporter.KEY_TIMEOUT, request.timeout().toMillis());
                }
                top.add(fieldMap);
            }
            output.put("total_count", count);
            output.put("top_requests", top);
            return output;
        }

        private Map<String, Object> convertOrphanMetadataOld(Queue<Request<?>> requests, long count, String serviceType) {
            HashMap<String, Object> output = new HashMap<String, Object>();
            ArrayList top = new ArrayList();
            for (Request request : requests) {
                HashMap<String, Object> fieldMap = new HashMap<String, Object>();
                if (request != null) {
                    long serverDuration;
                    String name = request.getClass().getSimpleName().replace("Request", "").toLowerCase();
                    fieldMap.put("s", name);
                    String operationId = request.operationId();
                    if (operationId != null) {
                        fieldMap.put("i", operationId);
                    }
                    if (request instanceof KeyValueRequest) {
                        fieldMap.put("b", ((KeyValueRequest)request).bucket());
                    } else if (request instanceof ViewRequest) {
                        fieldMap.put("b", ((ViewRequest)request).bucket());
                    }
                    String localId = request.context().lastChannelId();
                    if (localId != null) {
                        fieldMap.put("c", RedactableArgument.redactSystem(localId));
                    }
                    HostAndPort local = request.context().lastDispatchedFrom();
                    HostAndPort peer = request.context().lastDispatchedTo();
                    if (local != null) {
                        fieldMap.put("l", RedactableArgument.redactSystem(local.toString()));
                    }
                    if (peer != null) {
                        fieldMap.put("r", RedactableArgument.redactSystem(peer.toString()));
                    }
                    if ((serverDuration = request.context().serverLatency()) > 0L) {
                        fieldMap.put("d", serverDuration);
                    }
                    long timeout = request.timeout().toMillis();
                    fieldMap.put("t", timeout);
                }
                top.add(fieldMap);
            }
            output.put("service", serviceType);
            output.put("count", count);
            output.put("top", top);
            return output;
        }

        void logOrphans(Map<String, Object> toLogNew, List<Map<String, Object>> toLogOld) {
            OrphanReporter.this.eventBus.publish(new OrphansRecordedEvent(OrphanReporter.this.emitInterval, toLogNew, toLogOld));
        }
    }
}

