/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.loader;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.config.ConfigVersion;
import com.couchbase.client.core.config.ProposedGlobalConfigContext;
import com.couchbase.client.core.error.ConfigException;
import com.couchbase.client.core.error.GlobalConfigNotFoundException;
import com.couchbase.client.core.error.UnsupportedConfigMechanismException;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.CarrierGlobalConfigRequest;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import reactor.core.publisher.Mono;

public class GlobalLoader {
    private final Core core;

    public GlobalLoader(Core core) {
        this.core = core;
    }

    public Mono<ProposedGlobalConfigContext> load(NodeIdentifier seed, int port) {
        return this.core.ensureServiceAt(seed, ServiceType.KV, port, Optional.empty()).then(this.discoverConfig(seed)).map(config -> new String((byte[])config, StandardCharsets.UTF_8)).map(config -> config.replace("$HOST", seed.address())).map(config -> new ProposedGlobalConfigContext((String)config, seed.address())).onErrorResume(ex -> Mono.error(ex instanceof ConfigException ? ex : new ConfigException("Caught exception while loading global config.", (Throwable)ex)));
    }

    private Mono<byte[]> discoverConfig(NodeIdentifier seed) {
        CoreContext ctx = this.core.context();
        return Mono.defer(() -> {
            CarrierGlobalConfigRequest request = new CarrierGlobalConfigRequest(ctx.environment().timeoutConfig().connectTimeout(), ctx, (RetryStrategy)BestEffortRetryStrategy.INSTANCE, seed, ConfigVersion.ZERO);
            this.core.send(request);
            return Reactor.wrap(request, request.response(), true);
        }).map(response -> {
            if (response.status().success()) {
                return response.content();
            }
            if (response.status() == ResponseStatus.UNSUPPORTED || response.status() == ResponseStatus.NO_BUCKET) {
                throw new UnsupportedConfigMechanismException();
            }
            if (response.status() == ResponseStatus.NOT_FOUND) {
                throw new GlobalConfigNotFoundException();
            }
            throw new ConfigException("Received unexpected error status from GlobalLoader: " + response);
        });
    }
}

