/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS;

import com.couchbase.client.core.deps.org.xbill.DNS.DNSInput;
import com.couchbase.client.core.deps.org.xbill.DNS.DNSOutput;
import com.couchbase.client.core.deps.org.xbill.DNS.EDNSOption;
import com.couchbase.client.core.deps.org.xbill.DNS.WireParseException;
import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;

public class TcpKeepaliveOption
extends EDNSOption {
    private Integer timeout;
    private static final Duration UPPER_LIMIT = Duration.ofMillis(0x640000L);

    public TcpKeepaliveOption() {
        super(11);
        this.timeout = null;
    }

    public TcpKeepaliveOption(int t) {
        super(11);
        if (t < 0 || t > 65535) {
            throw new IllegalArgumentException("timeout must be betwee 0 and 65535");
        }
        this.timeout = t;
    }

    public TcpKeepaliveOption(Duration t) {
        super(11);
        if (t.isNegative() || t.compareTo(UPPER_LIMIT) >= 0) {
            throw new IllegalArgumentException("timeout must be between 0 and 6553.6 seconds (exclusively)");
        }
        this.timeout = (int)t.toMillis() / 100;
    }

    public OptionalInt getTimeout() {
        return this.timeout == null ? OptionalInt.empty() : OptionalInt.of(this.timeout);
    }

    public Optional<Duration> getTimeoutDuration() {
        return this.timeout != null ? Optional.of(Duration.ofMillis((long)this.timeout.intValue() * 100L)) : Optional.empty();
    }

    @Override
    void optionFromWire(DNSInput in) throws IOException {
        int length = in.remaining();
        switch (length) {
            case 0: {
                this.timeout = null;
                break;
            }
            case 2: {
                this.timeout = in.readU16();
                break;
            }
            default: {
                throw new WireParseException("invalid length (" + length + ") of the data in the edns_tcp_keepalive option");
            }
        }
    }

    @Override
    void optionToWire(DNSOutput out) {
        if (this.timeout != null) {
            out.writeU16(this.timeout);
        }
    }

    @Override
    String optionToString() {
        return this.timeout != null ? String.valueOf(this.timeout) : "-";
    }
}

