/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.events.endpoint.EndpointDisconnectDelayedEvent;
import com.couchbase.client.core.cnc.events.endpoint.EndpointDisconnectResumedEvent;
import com.couchbase.client.core.deps.io.netty.channel.EventLoopGroup;
import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.CircuitBreakerConfig;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.service.ServiceContext;
import com.couchbase.client.core.service.ServiceType;

abstract class DeferredCloseEndpoint
extends BaseEndpoint {
    private volatile boolean closeWhenDone = false;

    DeferredCloseEndpoint(String hostname, int port, EventLoopGroup eventLoopGroup, ServiceContext serviceContext, CircuitBreakerConfig circuitBreakerConfig, ServiceType serviceType, boolean pipelined) {
        super(hostname, port, eventLoopGroup, serviceContext, circuitBreakerConfig, serviceType, pipelined);
    }

    @Override
    public synchronized void disconnect() {
        if (this.outstandingRequests() > 0L) {
            this.closeWhenDone();
        } else {
            super.disconnect();
        }
    }

    private void closeWhenDone() {
        this.closeWhenDone = true;
        ((EndpointContext)this.endpointContext.get()).environment().eventBus().publish(new EndpointDisconnectDelayedEvent((EndpointContext)this.endpointContext.get()));
    }

    @Override
    @Stability.Internal
    public synchronized void markRequestCompletion() {
        super.markRequestCompletion();
        if (this.closeWhenDone && this.outstandingRequests() <= 0L) {
            ((EndpointContext)this.endpointContext.get()).environment().eventBus().publish(new EndpointDisconnectResumedEvent((EndpointContext)this.endpointContext.get()));
            this.closeChannel(this.channel);
            this.closeWhenDone = false;
        }
    }
}

