/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error.transaction;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;

@Stability.Internal
public class TransactionOperationFailedException
extends CouchbaseException {
    private final boolean autoRollbackAttempt;
    private final boolean retryTransaction;
    private final FinalErrorToRaise toRaise;

    public TransactionOperationFailedException(boolean autoRollbackAttempt, boolean retryTransaction, Throwable cause, FinalErrorToRaise toRaise) {
        super("Internal transaction error", cause);
        this.autoRollbackAttempt = autoRollbackAttempt;
        this.retryTransaction = retryTransaction;
        this.toRaise = toRaise;
    }

    @Stability.Internal
    public boolean autoRollbackAttempt() {
        return this.autoRollbackAttempt;
    }

    @Stability.Internal
    public boolean retryTransaction() {
        return this.retryTransaction;
    }

    @Stability.Internal
    public FinalErrorToRaise toRaise() {
        return this.toRaise;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransactionOperationFailedException {");
        if (this.getCause() != null) {
            sb.append("cause:");
            sb.append(RedactableArgument.redactUser(this.getCause().getClass().getName()));
        }
        sb.append(", retry:");
        sb.append(this.retryTransaction);
        sb.append(", autoRollback:");
        sb.append(this.autoRollbackAttempt);
        if (!this.retryTransaction) {
            sb.append(", raise:");
            sb.append((Object)this.toRaise);
        }
        sb.append("}");
        return sb.toString();
    }

    @Stability.Internal
    public static enum FinalErrorToRaise {
        TRANSACTION_SUCCESS,
        TRANSACTION_FAILED,
        TRANSACTION_EXPIRED,
        TRANSACTION_COMMIT_AMBIGUOUS,
        TRANSACTION_FAILED_POST_COMMIT;

    }

    public static class Builder {
        private boolean rollbackAttempt = true;
        private boolean retryTransaction = false;
        private Throwable cause = null;
        private FinalErrorToRaise toRaise = FinalErrorToRaise.TRANSACTION_FAILED;

        private Builder() {
        }

        public static Builder createError() {
            return new Builder();
        }

        public Builder raiseException(FinalErrorToRaise toRaise) {
            this.toRaise = toRaise;
            return this;
        }

        public Builder doNotRollbackAttempt() {
            this.rollbackAttempt = false;
            return this;
        }

        public Builder rollbackAttempt(boolean value) {
            this.rollbackAttempt = value;
            return this;
        }

        public Builder retryTransaction() {
            this.retryTransaction = true;
            return this;
        }

        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public TransactionOperationFailedException build() {
            return new TransactionOperationFailedException(this.rollbackAttempt, this.retryTransaction, this.cause, this.toRaise);
        }
    }
}

