/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.BucketNotFoundException;
import com.couchbase.client.core.manager.bucket.CoreBucketSettings;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@Stability.Internal
public interface CoreBucketManagerOps {
    public CompletableFuture<Void> createBucket(CoreBucketSettings var1, CoreCommonOptions var2);

    public CompletableFuture<Void> updateBucket(CoreBucketSettings var1, CoreCommonOptions var2);

    public CompletableFuture<Void> dropBucket(String var1, CoreCommonOptions var2);

    default public CompletableFuture<CoreBucketSettings> getBucket(String bucketName, CoreCommonOptions options) {
        return this.getAllBuckets(options).thenApply(buckets -> Optional.ofNullable((CoreBucketSettings)buckets.get(bucketName)).orElseThrow(() -> new BucketNotFoundException(bucketName)));
    }

    public CompletableFuture<Map<String, CoreBucketSettings>> getAllBuckets(CoreCommonOptions var1);

    public CompletableFuture<Void> flushBucket(String var1, CoreCommonOptions var2);
}

