/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.msg.kv.SubDocumentOpResponseStatus;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class SubDocumentField
implements Serializable {
    private static final long serialVersionUID = 227930811730226484L;
    private final SubDocumentOpResponseStatus status;
    @Nullable
    private final CouchbaseException error;
    private final byte[] value;
    private final String path;
    private final SubdocCommandType type;

    public SubDocumentField(SubDocumentOpResponseStatus status, Optional<CouchbaseException> error, byte[] value, String path, SubdocCommandType type) {
        this.status = Objects.requireNonNull(status);
        this.error = error.orElse(null);
        this.value = Objects.requireNonNull(value);
        this.path = Objects.requireNonNull(path);
        this.type = Objects.requireNonNull(type);
    }

    public SubDocumentOpResponseStatus status() {
        return this.status;
    }

    public Optional<CouchbaseException> error() {
        return Optional.ofNullable(this.error);
    }

    public void throwErrorIfPresent() {
        if (this.error != null) {
            throw this.error;
        }
    }

    public byte[] value() {
        return this.value;
    }

    public String path() {
        return this.path;
    }

    public SubdocCommandType type() {
        return this.type;
    }

    public String toString() {
        return "SubdocField{status=" + (Object)((Object)this.status) + ", value=" + new String(this.value, StandardCharsets.UTF_8) + ", path='" + this.path + '\'' + '}';
    }
}

