/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.util.HostAndPort;
import java.util.NoSuchElementException;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class NodeIdentifier {
    private final String canonicalHost;
    private final int canonicalManagerPort;
    @Nullable
    private final String hostForNetworkConnections;

    @Deprecated
    public NodeIdentifier(String canonicalHost, int canonicalManagerPort) {
        this.canonicalHost = canonicalHost;
        this.canonicalManagerPort = canonicalManagerPort;
        this.hostForNetworkConnections = null;
    }

    @Stability.Internal
    public static NodeIdentifier forBootstrap(String bootstrapHost, int bootstrapPort) {
        return new NodeIdentifier(new HostAndPort(bootstrapHost, bootstrapPort), bootstrapHost);
    }

    public NodeIdentifier(HostAndPort canonicalAddress, String hostForNetworkConnections) {
        this.canonicalHost = canonicalAddress.host();
        this.canonicalManagerPort = canonicalAddress.port();
        this.hostForNetworkConnections = Objects.requireNonNull(hostForNetworkConnections);
    }

    public String hostForNetworkConnections() throws NoSuchElementException {
        if (this.hostForNetworkConnections == null) {
            throw new NoSuchElementException("This NodeIdentifier (" + this + ") doesn't have the host to use for network connections. It might have been created by a legacy config parser or some other component that did not specify it.");
        }
        return this.hostForNetworkConnections;
    }

    public String address() {
        return this.canonicalHost;
    }

    public int managerPort() {
        return this.canonicalManagerPort;
    }

    public String toString() {
        return "NodeIdentifier{canonicalAddress=" + RedactableArgument.redactSystem(this.canonicalHost + ":" + this.canonicalManagerPort) + ", hostForNetworkConnections=" + this.hostForNetworkConnections + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeIdentifier that = (NodeIdentifier)o;
        return this.canonicalManagerPort == that.canonicalManagerPort && Objects.equals(this.canonicalHost, that.canonicalHost);
    }

    public int hashCode() {
        return Objects.hash(this.canonicalHost, this.canonicalManagerPort);
    }
}

