/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.projections;

import com.couchbase.client.core.projections.PathArray;
import com.couchbase.client.core.projections.PathElement;
import com.couchbase.client.core.projections.PathObjectOrField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JsonPathParser {
    private JsonPathParser() {
    }

    static String debugPos(int idx) {
        return "position " + idx;
    }

    public static List<PathElement> parse(String path) {
        int elemIdx = 0;
        int idx = 0;
        int len = path.length();
        ArrayList<PathElement> ret = new ArrayList<PathElement>();
        while (idx < len) {
            char ch = path.charAt(idx);
            ++idx;
            if (ch == '.') {
                String first = path.substring(elemIdx, idx - 1);
                elemIdx = idx;
                ret.add(new PathObjectOrField(first));
                continue;
            }
            if (ch != '[') continue;
            int arrayIdxStart = idx;
            Integer out = null;
            while (idx < len && out == null) {
                char arrayIdxCh = path.charAt(idx);
                if (arrayIdxCh == ']') {
                    String arrayIdxStr = path.substring(arrayIdxStart, idx);
                    out = Integer.parseInt(arrayIdxStr);
                } else if (arrayIdxCh < '0' || arrayIdxCh > '9') {
                    throw new IllegalArgumentException("Found unexpected non-digit in middle of array index at " + JsonPathParser.debugPos(idx));
                }
                ++idx;
            }
            if (out == null) {
                throw new IllegalArgumentException("Could not find ']' to complete array index");
            }
            String first = path.substring(elemIdx, arrayIdxStart - 1);
            elemIdx = idx;
            ret.add(new PathArray(first, out));
            if (idx >= len || path.charAt(idx) != '.') continue;
            elemIdx = ++idx;
        }
        if (idx != elemIdx) {
            String first = path.substring(elemIdx, idx);
            ret.add(new PathObjectOrField(first));
        }
        return Collections.unmodifiableList(ret);
    }
}

