/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.query;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryProfile;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.query.CoreQueryScanConsistency;
import com.couchbase.client.core.api.query.CoreReactiveQueryResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.google.protobuf.ByteString;
import com.couchbase.client.core.deps.io.grpc.stub.StreamObserver;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.protostellar.CoreProtostellarAccessorsStreaming;
import com.couchbase.client.core.protostellar.CoreProtostellarErrorHandlingUtil;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.protostellar.query.ProtostellarCoreQueryMetaData;
import com.couchbase.client.core.protostellar.query.ProtostellarCoreQueryResult;
import com.couchbase.client.core.protostellar.query.ProtostellarCoreReactiveQueryResult;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.ProtostellarUtil;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.query.v1.QueryRequest;
import com.couchbase.client.protostellar.query.v1.QueryResponse;
import com.couchbase.client.protostellar.query.v1.QueryServiceGrpc;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ProtostellarCoreQueryOps
implements CoreQueryOps {
    private final CoreProtostellar core;

    public ProtostellarCoreQueryOps(CoreProtostellar core) {
        this.core = Objects.requireNonNull(core);
    }

    @Override
    public CoreQueryResult queryBlocking(String statement, CoreQueryOptions options, @Nullable CoreQueryContext queryContext, @Nullable NodeIdentifier target, @Nullable Function<Throwable, RuntimeException> errorConverter) {
        ProtostellarRequest<QueryRequest> request = ProtostellarCoreQueryOps.request(this.core, statement, options, queryContext, target);
        List<QueryResponse> responses = CoreProtostellarAccessorsStreaming.blocking(this.core, request, (endpoint, stream) -> ((QueryServiceGrpc.QueryServiceStub)endpoint.queryStub().withDeadline(request.deadline())).query((QueryRequest)request.request(), (StreamObserver<QueryResponse>)stream), error -> CoreProtostellarErrorHandlingUtil.convertException(this.core, request, error));
        return new ProtostellarCoreQueryResult(responses);
    }

    @Override
    public CoreAsyncResponse<CoreQueryResult> queryAsync(String statement, CoreQueryOptions options, @Nullable CoreQueryContext queryContext, @Nullable NodeIdentifier target, @Nullable Function<Throwable, RuntimeException> errorConverter) {
        ProtostellarRequest<QueryRequest> request = ProtostellarCoreQueryOps.request(this.core, statement, options, queryContext, target);
        CoreAsyncResponse responses = CoreProtostellarAccessorsStreaming.async(this.core, request, (endpoint, stream) -> ((QueryServiceGrpc.QueryServiceStub)endpoint.queryStub().withDeadline(request.deadline())).query((QueryRequest)request.request(), (StreamObserver<QueryResponse>)stream), error -> CoreProtostellarErrorHandlingUtil.convertException(this.core, request, error));
        return responses.map(ProtostellarCoreQueryResult::new);
    }

    @Override
    public Mono<CoreReactiveQueryResult> queryReactive(String statement, CoreQueryOptions options, @Nullable CoreQueryContext queryContext, @Nullable NodeIdentifier target, @Nullable Function<Throwable, RuntimeException> errorConverter) {
        return Mono.defer(() -> {
            try {
                ProtostellarRequest<QueryRequest> request = ProtostellarCoreQueryOps.request(this.core, statement, options, queryContext, target);
                Sinks.Many rows = Sinks.many().unicast().onBackpressureBuffer();
                Sinks.One metaData = Sinks.one();
                Flux responses = CoreProtostellarAccessorsStreaming.reactive(this.core, request, (endpoint, stream) -> ((QueryServiceGrpc.QueryServiceStub)endpoint.queryStub().withDeadline(request.deadline())).query((QueryRequest)request.request(), (StreamObserver<QueryResponse>)stream), error -> CoreProtostellarErrorHandlingUtil.convertException(this.core, request, error));
                responses.publishOn(this.core.context().environment().scheduler()).subscribe(response -> {
                    response.getRowsList().forEach(row -> rows.tryEmitNext(new QueryChunkRow(row.toByteArray())).orThrow());
                    if (response.hasMetaData()) {
                        metaData.tryEmitValue(new ProtostellarCoreQueryMetaData(response.getMetaData())).orThrow();
                    }
                }, throwable -> rows.tryEmitError((Throwable)throwable).orThrow(), () -> rows.tryEmitComplete().orThrow());
                return Mono.just(new ProtostellarCoreReactiveQueryResult(rows.asFlux(), metaData.asMono()));
            }
            catch (Throwable err) {
                return Mono.error(err);
            }
        });
    }

    private static ProtostellarRequest<QueryRequest> request(CoreProtostellar core, String statement, CoreQueryOptions opts, @Nullable CoreQueryContext queryContext, @Nullable NodeIdentifier target) {
        if (target != null) {
            throw CoreProtostellarUtil.unsupportedInProtostellar("Targetting a specific query node");
        }
        if (opts.asTransaction()) {
            throw CoreProtostellarUtil.unsupportedCurrentlyInProtostellar();
        }
        Validators.notNullOrEmpty(statement, "Statement", () -> new ReducedQueryErrorContext(statement));
        QueryRequest.Builder request = ProtostellarCoreQueryOps.convertOptions(opts);
        request.setStatement(statement);
        if (queryContext != null) {
            request.setBucketName(queryContext.bucket());
            request.setScopeName(queryContext.scope());
        }
        Duration timeout = opts.commonOptions().timeout().orElse(core.context().environment().timeoutConfig().queryTimeout());
        RequestSpan span = CoreProtostellarUtil.createSpan(core, "query", CoreDurability.NONE, opts.commonOptions().parentSpan().orElse(null));
        span.attribute("db.statement", statement);
        return new ProtostellarRequest<QueryRequest>(request.build(), core, ServiceType.QUERY, "query", span, timeout, opts.readonly(), opts.commonOptions().retryStrategy().orElse(core.context().environment().retryStrategy()), opts.commonOptions().clientContext(), 0L, ctx -> ctx.put("statement", RedactableArgument.redactMeta(statement)));
    }

    static QueryRequest.ScanConsistency toProtostellar(CoreQueryScanConsistency scanConsistency) {
        return QueryRequest.ScanConsistency.valueOf("SCAN_CONSISTENCY_" + scanConsistency.name());
    }

    private static QueryRequest.Builder convertOptions(CoreQueryOptions opts) {
        JsonNode raw;
        boolean positionalPresent;
        QueryRequest.Builder input = QueryRequest.newBuilder();
        input.setClientContextId(opts.clientContextId() == null ? UUID.randomUUID().toString() : opts.clientContextId());
        if (opts.scanConsistency() != null) {
            input.setScanConsistency(ProtostellarCoreQueryOps.toProtostellar(opts.scanConsistency()));
        }
        boolean bl = positionalPresent = opts.positionalParameters() != null && !opts.positionalParameters().isEmpty();
        if (opts.namedParameters() != null && !opts.namedParameters().isEmpty()) {
            if (positionalPresent) {
                throw InvalidArgumentException.fromMessage("Both positional and named parameters cannot be present at the same time!");
            }
            opts.namedParameters().fieldNames().forEachRemaining(key -> {
                JsonNode value = opts.namedParameters().get((String)key);
                try {
                    ByteString bs = ByteString.copyFrom(Mapper.writer().writeValueAsBytes(value));
                    input.putNamedParameters((String)key, bs);
                }
                catch (JsonProcessingException e) {
                    throw new InvalidArgumentException("Unable to JSON encode named parameter " + key, e, null);
                }
            });
        }
        if (positionalPresent) {
            opts.positionalParameters().iterator().forEachRemaining(it -> {
                try {
                    input.addPositionalParameters(ByteString.copyFrom(Mapper.writer().writeValueAsBytes(it)));
                }
                catch (JsonProcessingException e) {
                    throw new InvalidArgumentException("Unable to JSON encode positional parameter " + it, e, null);
                }
            });
        }
        if (opts.scanConsistency() == CoreQueryScanConsistency.REQUEST_PLUS) {
            input.setScanConsistency(QueryRequest.ScanConsistency.SCAN_CONSISTENCY_REQUEST_PLUS);
        }
        if (opts.consistentWith() != null) {
            for (MutationToken token : opts.consistentWith().tokens()) {
                input.addConsistentWith(com.couchbase.client.protostellar.kv.v1.MutationToken.newBuilder().setSeqNo(token.sequenceNumber()).setVbucketId(token.partitionID()).setVbucketUuid(token.partitionUUID()).setBucketName(token.bucketName()).build());
            }
        }
        if (opts.profile() != null && opts.profile() != CoreQueryProfile.OFF) {
            switch (opts.profile()) {
                case TIMINGS: {
                    input.setProfileMode(QueryRequest.ProfileMode.PROFILE_MODE_TIMINGS);
                    break;
                }
                case PHASES: {
                    input.setProfileMode(QueryRequest.ProfileMode.PROFILE_MODE_PHASES);
                    break;
                }
                default: {
                    throw new InvalidArgumentException("Unknown profile mode " + (Object)((Object)opts.profile()), null, null);
                }
            }
        }
        QueryRequest.TuningOptions.Builder tuning = null;
        if (opts.scanWait() != null) {
            if (tuning == null) {
                tuning = QueryRequest.TuningOptions.newBuilder();
            }
            tuning.setScanWait(ProtostellarUtil.convert(opts.scanWait()));
        }
        if (opts.maxParallelism() != null) {
            if (tuning == null) {
                tuning = QueryRequest.TuningOptions.newBuilder();
            }
            tuning.setMaxParallelism(opts.maxParallelism());
        }
        if (opts.pipelineCap() != null) {
            if (tuning == null) {
                tuning = QueryRequest.TuningOptions.newBuilder();
            }
            tuning.setPipelineCap(opts.pipelineCap());
        }
        if (opts.pipelineBatch() != null) {
            if (tuning == null) {
                tuning = QueryRequest.TuningOptions.newBuilder();
            }
            tuning.setPipelineBatch(opts.pipelineBatch());
        }
        if (opts.scanCap() != null) {
            if (tuning == null) {
                tuning = QueryRequest.TuningOptions.newBuilder();
            }
            tuning.setScanCap(opts.scanCap());
        }
        if (!opts.metrics()) {
            if (tuning == null) {
                tuning = QueryRequest.TuningOptions.newBuilder();
            }
            tuning.setDisableMetrics(!opts.metrics());
        }
        if (opts.readonly()) {
            input.setReadOnly(opts.readonly());
        }
        if (opts.flexIndex()) {
            input.setFlexIndex(opts.flexIndex());
        }
        if (opts.preserveExpiry() != null) {
            input.setPreserveExpiry(opts.preserveExpiry());
        }
        if (!opts.adhoc()) {
            input.setPrepared(true);
        }
        if ((raw = opts.raw()) != null && !raw.isEmpty()) {
            throw new FeatureNotAvailableException("Raw options cannot be used together with Protostellar");
        }
        if (tuning != null) {
            input.setTuningOptions(tuning);
        }
        return input;
    }
}

