/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import java.util.Map;
import java.util.Optional;

public class ServiceContext
extends CoreContext {
    private final String remoteHostname;
    private final int remotePort;
    private final ServiceType serviceType;
    private final Optional<String> bucket;

    public ServiceContext(CoreContext ctx, String remoteHostname, int remotePort, ServiceType serviceType, Optional<String> bucket) {
        super(ctx.core(), ctx.id(), ctx.environment(), ctx.authenticator());
        this.remoteHostname = remoteHostname;
        this.remotePort = remotePort;
        this.bucket = bucket;
        this.serviceType = serviceType;
    }

    public String remoteHostname() {
        return this.remoteHostname;
    }

    public int remotePort() {
        return this.remotePort;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        input.put("remote", RedactableArgument.redactSystem(this.remoteHostname() + ":" + this.remotePort()));
        input.put("type", (Object)this.serviceType);
        this.bucket.ifPresent(b -> input.put("bucket", b));
    }

    public ServiceType serviceType() {
        return this.serviceType;
    }

    public Optional<String> bucket() {
        return this.bucket;
    }
}

