/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.components;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.transaction.ActiveTransactionRecordEntryNotFoundException;
import com.couchbase.client.core.error.transaction.ActiveTransactionRecordNotFoundException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.msg.kv.SubdocGetResponse;
import com.couchbase.client.core.transaction.CoreTransactionGetResult;
import com.couchbase.client.core.transaction.components.ActiveTransactionRecord;
import com.couchbase.client.core.transaction.components.ActiveTransactionRecordEntry;
import com.couchbase.client.core.transaction.components.ActiveTransactionRecordUtil;
import com.couchbase.client.core.transaction.config.CoreMergedTransactionConfig;
import com.couchbase.client.core.transaction.error.internal.ErrorClass;
import com.couchbase.client.core.transaction.forwards.CoreTransactionsSupportedExtensions;
import com.couchbase.client.core.transaction.forwards.ForwardCompatibility;
import com.couchbase.client.core.transaction.forwards.ForwardCompatibilityStage;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import com.couchbase.client.core.transaction.support.OptionsUtil;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.core.transaction.util.DebugUtil;
import com.couchbase.client.core.transaction.util.MeteringUnits;
import com.couchbase.client.core.transaction.util.TransactionKVHandler;
import com.couchbase.client.core.util.CbPreconditions;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Stability.Internal
public class DocumentGetter {
    private DocumentGetter() {
    }

    public static Mono<Optional<CoreTransactionGetResult>> getAsync(Core core, CoreTransactionLogger LOGGER, CollectionIdentifier collection, CoreMergedTransactionConfig config, String docId, String byAttemptId, boolean justReturn, @Nullable SpanWrapper span, Optional<String> resolvingMissingATREntry, MeteringUnits.MeteringUnitsBuilder units, CoreTransactionsSupportedExtensions supported) {
        return DocumentGetter.justGetDoc(core, collection, docId, OptionsUtil.kvTimeoutNonMutating(core), span, true, LOGGER, units).flatMap(origTrans -> {
            if (justReturn) {
                return Mono.just(origTrans.map(v -> (CoreTransactionGetResult)v.getT1()));
            }
            if (origTrans.isPresent()) {
                CoreTransactionGetResult r = (CoreTransactionGetResult)((Tuple2)origTrans.get()).getT1();
                SubdocGetResponse lir = (SubdocGetResponse)((Tuple2)origTrans.get()).getT2();
                if (!r.links().isDocumentInTransaction()) {
                    if (lir.isDeleted()) {
                        return Mono.just(Optional.empty());
                    }
                    return Mono.just(Optional.of(r));
                }
                if (r.links().stagedAttemptId().get().equals(byAttemptId)) {
                    LOGGER.info(byAttemptId, "doc {} is in our own transaction attempt - RYOW", DebugUtil.docId(collection, docId));
                    if (r.links().op().get().equals("remove")) {
                        return Mono.just(Optional.empty());
                    }
                    return Mono.just(Optional.of(CoreTransactionGetResult.createFrom(r, r.links().stagedContentJsonOrBinary().get())));
                }
                if (resolvingMissingATREntry.equals(r.links().stagedAttemptId())) {
                    if (r.links().op().isPresent() && r.links().op().get().equals("insert")) {
                        LOGGER.info(byAttemptId, "doc {} is in the same transaction as last time indicating it's part of a lost PENDING transaction, it's a staged insert so returning empty", DebugUtil.docId(collection, docId));
                        return Mono.just(Optional.empty());
                    }
                    LOGGER.info(byAttemptId, "doc {} is in the same transaction as last time indicating it's part of a lost PENDING transaction, returning body", DebugUtil.docId(collection, docId));
                    return Mono.just(Optional.of(r));
                }
                CollectionIdentifier atrCollection = new CollectionIdentifier(r.links().atrBucketName().get(), r.links().atrScopeName(), r.links().atrCollectionName());
                LOGGER.info(byAttemptId, "doc {} is in a transaction {}, looking up its status from ATR {} (MAV read)", DebugUtil.docId(collection, docId), r.links().stagedAttemptId(), ActiveTransactionRecordUtil.getAtrDebug(atrCollection, r.links().atrId().get()));
                return DocumentGetter.lookupStatusFromATR(core, atrCollection, r, byAttemptId, config, span, LOGGER, units, supported);
            }
            LOGGER.info(byAttemptId, "doc {} is not in a transaction", DebugUtil.docId(collection, docId));
            return Mono.just(origTrans.map(v -> (CoreTransactionGetResult)v.getT1()));
        });
    }

    public static Mono<Optional<Tuple2<CoreTransactionGetResult, SubdocGetResponse>>> justGetDoc(Core core, CollectionIdentifier collection, String docId, Duration timeout, @Nullable SpanWrapper span, boolean accessDeleted, CoreTransactionLogger logger, MeteringUnits.MeteringUnitsBuilder units) {
        return TransactionKVHandler.lookupIn(core, collection, docId, timeout, accessDeleted, OptionsUtil.createClientContext("DocumentGetter::justGetDoc"), span, Arrays.asList(new SubdocGetRequest.Command(SubdocCommandType.GET, "txn.id", true, 0), new SubdocGetRequest.Command(SubdocCommandType.GET, "txn.atr", true, 1), new SubdocGetRequest.Command(SubdocCommandType.GET, "txn.op.type", true, 2), new SubdocGetRequest.Command(SubdocCommandType.GET, "txn.op.stgd", true, false, 3), new SubdocGetRequest.Command(SubdocCommandType.GET, "txn.op.crc32", true, 4), new SubdocGetRequest.Command(SubdocCommandType.GET, "txn.restore", true, 5), new SubdocGetRequest.Command(SubdocCommandType.GET, "txn.fc", true, 6), new SubdocGetRequest.Command(SubdocCommandType.GET, "$document", true, 7), new SubdocGetRequest.Command(SubdocCommandType.GET, "txn.op.bin", true, true, 8), new SubdocGetRequest.Command(SubdocCommandType.GET, "txn.aux", true, 9), new SubdocGetRequest.Command(SubdocCommandType.GET_DOC, "", false, 10))).map(fragment -> {
            units.add(fragment.flexibleExtras());
            try {
                return Optional.of(Tuples.of(CoreTransactionGetResult.createFrom(collection, docId, fragment), fragment));
            }
            catch (Throwable err) {
                logger.info("", "Hit error while decoding doc's transaction metadata {}.{}.{}.{} {}", collection.bucket(), collection.scope(), collection.collection(), docId, DebugUtil.dbg(err));
                for (int i = 0; i < 10; ++i) {
                    DocumentGetter.dumpRawLookupInField(logger, fragment, 0);
                }
                throw new RuntimeException(err);
            }
        }).onErrorResume(err -> {
            units.add((Throwable)err);
            ErrorClass ec = ErrorClass.classify(err);
            if (ec == ErrorClass.FAIL_DOC_NOT_FOUND) {
                return Mono.just(Optional.empty());
            }
            return Mono.error(err);
        });
    }

    private static void dumpRawLookupInField(CoreTransactionLogger logger, SubdocGetResponse fragment, int index) {
        try {
            if (fragment.values()[index].status().success()) {
                byte[] raw = fragment.values()[index].value();
                String asStr = new String(raw, StandardCharsets.UTF_8);
                logger.info("", "Field {}: {}", index, asStr);
            } else {
                logger.info("", "Field {} not found", index);
            }
        }
        catch (Throwable err) {
            logger.info("", "Error on field {}: {}", index, DebugUtil.dbg(err));
        }
    }

    private static Mono<Optional<CoreTransactionGetResult>> lookupStatusFromATR(Core core, CollectionIdentifier collection, CoreTransactionGetResult doc, String byAttemptId, CoreMergedTransactionConfig config, SpanWrapper span, @Nullable CoreTransactionLogger logger, MeteringUnits.MeteringUnitsBuilder units, CoreTransactionsSupportedExtensions supported) {
        CbPreconditions.check(doc.links().isDocumentInTransaction());
        CbPreconditions.check(doc.links().atrId().isPresent());
        CbPreconditions.check(doc.links().stagedAttemptId().isPresent());
        String atrId = doc.links().atrId().get();
        String attemptIdOfDoc = doc.links().stagedAttemptId().get();
        return ActiveTransactionRecord.findEntryForTransaction(core, collection, atrId, attemptIdOfDoc, config, span, logger, units).onErrorResume(err -> {
            units.add((Throwable)err);
            ErrorClass ec = ErrorClass.classify(err);
            if (ec == ErrorClass.FAIL_DOC_NOT_FOUND) {
                return Mono.error(new ActiveTransactionRecordNotFoundException(atrId, attemptIdOfDoc));
            }
            return Mono.error(err);
        }).flatMap(atrDocOpt -> {
            if (!atrDocOpt.isPresent()) {
                return Mono.error(new ActiveTransactionRecordEntryNotFoundException(atrId, attemptIdOfDoc));
            }
            return DocumentGetter.atrFound(core, doc, byAttemptId, (ActiveTransactionRecordEntry)atrDocOpt.get(), logger, supported);
        });
    }

    private static Mono<Optional<CoreTransactionGetResult>> atrFound(Core core, CoreTransactionGetResult doc, String byAttemptId, ActiveTransactionRecordEntry entry, CoreTransactionLogger logger, CoreTransactionsSupportedExtensions supported) {
        if (doc.links().stagedAttemptId().isPresent() && entry.attemptId().equals(byAttemptId)) {
            if (doc.links().isDocumentBeingRemoved()) {
                return Mono.just(Optional.empty());
            }
            return Mono.just(Optional.of(CoreTransactionGetResult.createFrom(doc, doc.links().stagedContentJsonOrBinary().get())));
        }
        return ForwardCompatibility.check(core, ForwardCompatibilityStage.GETS_READING_ATR, entry.forwardCompatibility(), logger, supported).then(Mono.defer(() -> {
            logger.info(byAttemptId, "found ATR for MAV read in state: {}", entry);
            switch (entry.state()) {
                case COMMITTED: 
                case COMPLETED: {
                    if (doc.links().isDocumentBeingRemoved()) {
                        return Mono.just(Optional.empty());
                    }
                    return Mono.just(Optional.of(CoreTransactionGetResult.createFrom(doc, doc.links().stagedContentJsonOrBinary().get())));
                }
            }
            if (doc.links().op().isPresent() && doc.links().op().get().equals("insert")) {
                return Mono.just(Optional.empty());
            }
            return Mono.just(Optional.of(CoreTransactionGetResult.createFrom(doc, doc.contentAsBytes())));
        }));
    }
}

