/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.GlobalConfig;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.retry.reactor.Backoff;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.core.retry.reactor.RetryExhaustedException;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import reactor.core.publisher.Mono;

@Stability.Internal
public class ClusterCapabilitiesUtil {
    private static final Duration retryDelay = Duration.ofMillis(100L);

    private ClusterCapabilitiesUtil() {
    }

    public static Mono<Map<ServiceType, Set<ClusterCapabilities>>> waitForClusterCapabilities(Core core, Duration timeout) {
        return Mono.fromCallable(() -> {
            GlobalConfig globalConfig = core.clusterConfig().globalConfig();
            if (globalConfig != null) {
                return globalConfig.clusterCapabilities();
            }
            Map<String, BucketConfig> bucketConfigs = core.clusterConfig().bucketConfigs();
            if (bucketConfigs != null && !bucketConfigs.isEmpty()) {
                return bucketConfigs.values().iterator().next().clusterCapabilities();
            }
            throw new NullPointerException();
        }).retryWhen(Retry.anyOf(NullPointerException.class).timeout(timeout).backoff(Backoff.fixed(retryDelay)).toReactorRetry()).onErrorResume(err -> {
            if (err instanceof RetryExhaustedException) {
                return Mono.error(new UnambiguousTimeoutException("Timed out while waiting for global config", null));
            }
            return Mono.error(err);
        });
    }
}

