/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.DnsSrvResolver;
import com.couchbase.client.core.util.HostAndPort;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ForkJoinPool;
import javax.naming.NameNotFoundException;

@Stability.Internal
public class DnsSrv {
    public static final String DEFAULT_DNS_SERVICE = "_couchbase._tcp.";
    public static final String DEFAULT_DNS_SECURE_SERVICE = "_couchbases._tcp.";

    private DnsSrv() {
    }

    public static List<String> fromDnsSrv(String serviceName, boolean full, boolean secure) throws NameNotFoundException {
        String fullService = full ? serviceName : (secure ? DEFAULT_DNS_SECURE_SERVICE : DEFAULT_DNS_SERVICE) + serviceName;
        try {
            DnsSrvResolver resolver = new DnsSrvResolver(ForkJoinPool.commonPool());
            List<HostAndPort> results = resolver.resolve(fullService).blockOptional().orElseThrow(() -> new NoSuchElementException("No value present"));
            return CbCollections.transform(results, HostAndPort::host);
        }
        catch (RuntimeException e) {
            NameNotFoundException cause = CbThrowables.findCause(e, NameNotFoundException.class).orElse(null);
            if (cause != null) {
                throw cause;
            }
            throw e;
        }
    }
}

