/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Function;

@Stability.Internal
public class EnumLookupTable<E extends Enum<E>> {
    private final E[] indexToValue;

    private EnumLookupTable(Class<E> enumClass, Function<E, Integer> enumToIndex) {
        Enum[] enumValues = (Enum[])enumClass.getEnumConstants();
        int maxIndex = Arrays.stream(enumValues).mapToInt(enumToIndex::apply).max().orElse(0);
        if (maxIndex - enumValues.length > 1024) {
            throw new IllegalArgumentException("Lookup table is too sparse, would waste memory. Consider adding an alternate implementation backed by a Map instead of an array.");
        }
        this.indexToValue = (Enum[])Array.newInstance(enumClass, maxIndex + 1);
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            int index = enumToIndex.apply(e);
            if (this.indexToValue[index] != null) {
                throw new IllegalArgumentException("Index collision: enum values " + this.indexToValue[index] + " and " + e + " both have index " + index);
            }
            this.indexToValue[index] = e;
        }
    }

    public static <E extends Enum<E>> EnumLookupTable<E> create(Class<E> enumClass, Function<E, Integer> enumToIndex) {
        return new EnumLookupTable<E>(enumClass, enumToIndex);
    }

    public E getOrDefault(int index, E defaultValue) {
        try {
            E value = this.indexToValue[index];
            return value == null ? defaultValue : value;
        }
        catch (IndexOutOfBoundsException e) {
            if (index < 0) {
                throw new IllegalArgumentException("index must be positive but got " + index);
            }
            return defaultValue;
        }
    }
}

