/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.kv.CoreGetResult;
import com.couchbase.client.core.api.kv.CoreKvOps;
import com.couchbase.client.core.api.kv.CoreSubdocGetResult;
import com.couchbase.client.core.api.kv.CoreSubdocMutateResult;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.service.kv.ReplicaHelper;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncBinaryCollection;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.kv.ExistsOptions;
import com.couchbase.client.java.kv.ExistsResult;
import com.couchbase.client.java.kv.Expiry;
import com.couchbase.client.java.kv.GetAllReplicasOptions;
import com.couchbase.client.java.kv.GetAndLockOptions;
import com.couchbase.client.java.kv.GetAndTouchOptions;
import com.couchbase.client.java.kv.GetAnyReplicaOptions;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetReplicaResult;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.LookupInAllReplicasOptions;
import com.couchbase.client.java.kv.LookupInAnyReplicaOptions;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInReplicaResult;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.ScanOptions;
import com.couchbase.client.java.kv.ScanResult;
import com.couchbase.client.java.kv.ScanType;
import com.couchbase.client.java.kv.TouchOptions;
import com.couchbase.client.java.kv.UnlockOptions;
import com.couchbase.client.java.kv.UpsertOptions;
import com.couchbase.client.java.manager.query.AsyncCollectionQueryIndexManager;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncCollection {
    private final CoreCouchbaseOps couchbaseOps;
    private final ClusterEnvironment environment;
    private final CoreKeyspace keyspace;
    private final AsyncBinaryCollection asyncBinaryCollection;
    final CoreKvOps kvOps;
    private final AsyncCollectionQueryIndexManager queryIndexManager;
    private final AsyncCluster cluster;

    AsyncCollection(CoreKeyspace keyspace, CoreCouchbaseOps couchbaseOps, ClusterEnvironment environment, AsyncCluster cluster) {
        this.keyspace = Objects.requireNonNull(keyspace);
        this.couchbaseOps = Objects.requireNonNull(couchbaseOps);
        this.environment = Objects.requireNonNull(environment);
        this.cluster = Objects.requireNonNull(cluster);
        this.asyncBinaryCollection = new AsyncBinaryCollection(keyspace, couchbaseOps, cluster);
        this.kvOps = couchbaseOps.kvOps(keyspace);
        this.queryIndexManager = new AsyncCollectionQueryIndexManager(couchbaseOps.queryOps(), couchbaseOps.environment().requestTracer(), keyspace);
    }

    @Stability.Volatile
    public Core core() {
        return this.couchbaseOps.asCore();
    }

    @Stability.Volatile
    public AsyncCollectionQueryIndexManager queryIndexes() {
        return this.queryIndexManager;
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    public String name() {
        return this.keyspace.collection();
    }

    public String bucketName() {
        return this.keyspace.bucket();
    }

    public String scopeName() {
        return this.keyspace.scope();
    }

    public AsyncBinaryCollection binary() {
        return this.asyncBinaryCollection;
    }

    public CompletableFuture<GetResult> get(String id) {
        return this.get(id, ReactiveCollection.DEFAULT_GET_OPTIONS);
    }

    public CompletableFuture<GetResult> get(String id, GetOptions options) {
        Validators.notNull(options, "GetOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        GetOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.getAsync(opts, id, opts.projections(), opts.withExpiry()).thenApply(coreGetResult -> new GetResult((CoreGetResult)coreGetResult, transcoder));
    }

    public CompletableFuture<GetResult> getAndLock(String id, Duration lockTime) {
        return this.getAndLock(id, lockTime, ReactiveCollection.DEFAULT_GET_AND_LOCK_OPTIONS);
    }

    public CompletableFuture<GetResult> getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        Validators.notNull(options, "GetAndLockOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        GetAndLockOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.getAndLockAsync(opts, id, lockTime).thenApply(coreGetResult -> new GetResult((CoreGetResult)coreGetResult, transcoder));
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Duration expiry) {
        return this.getAndTouch(id, expiry, ReactiveCollection.DEFAULT_GET_AND_TOUCH_OPTIONS);
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        return this.getAndTouch(id, Expiry.relative(expiry), options);
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Instant expiry) {
        return this.getAndTouch(id, expiry, ReactiveCollection.DEFAULT_GET_AND_TOUCH_OPTIONS);
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Instant expiry, GetAndTouchOptions options) {
        return this.getAndTouch(id, Expiry.absolute(expiry), options);
    }

    private CompletableFuture<GetResult> getAndTouch(String id, Expiry expiry, GetAndTouchOptions options) {
        Validators.notNull(expiry, "Expiry", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        Validators.notNull(options, "GetAndTouchOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        GetAndTouchOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.getAndTouchAsync(opts, id, expiry.encode()).thenApply(coreGetResult -> new GetResult((CoreGetResult)coreGetResult, transcoder));
    }

    public CompletableFuture<List<CompletableFuture<GetReplicaResult>>> getAllReplicas(String id) {
        return this.getAllReplicas(id, ReactiveCollection.DEFAULT_GET_ALL_REPLICAS_OPTIONS);
    }

    public CompletableFuture<List<CompletableFuture<GetReplicaResult>>> getAllReplicas(String id, GetAllReplicasOptions options) {
        Validators.notNull(options, "GetAllReplicasOptions");
        GetAllReplicasOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return ReplicaHelper.getAllReplicasAsync(this.core(), this.keyspace.toCollectionIdentifier(), id, opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), opts.parentSpan().orElse(null), response -> GetReplicaResult.from(response, transcoder));
    }

    public CompletableFuture<GetReplicaResult> getAnyReplica(String id) {
        return this.getAnyReplica(id, ReactiveCollection.DEFAULT_GET_ANY_REPLICA_OPTIONS);
    }

    public CompletableFuture<GetReplicaResult> getAnyReplica(String id, GetAnyReplicaOptions options) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        Validators.notNull(options, "GetAnyReplicaOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        GetAnyReplicaOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return ReplicaHelper.getAnyReplicaAsync(this.core(), this.keyspace.toCollectionIdentifier(), id, opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), opts.parentSpan().orElse(null), response -> GetReplicaResult.from(response, transcoder));
    }

    public CompletableFuture<ExistsResult> exists(String id) {
        return this.exists(id, ReactiveCollection.DEFAULT_EXISTS_OPTIONS);
    }

    public CompletableFuture<ExistsResult> exists(String id, ExistsOptions options) {
        ExistsOptions.Built opts = Validators.notNull(options, "options").build();
        return this.kvOps.existsAsync(opts, id).toFuture().thenApply(ExistsResult::from);
    }

    public CompletableFuture<MutationResult> remove(String id) {
        return this.remove(id, ReactiveCollection.DEFAULT_REMOVE_OPTIONS);
    }

    public CompletableFuture<MutationResult> remove(String id, RemoveOptions options) {
        Validators.notNull(options, "RemoveOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        RemoveOptions.Built opts = options.build();
        return this.kvOps.removeAsync(opts, id, opts.cas(), opts.toCoreDurability()).toFuture().thenApply(MutationResult::new);
    }

    public CompletableFuture<MutationResult> insert(String id, Object content) {
        return this.insert(id, content, ReactiveCollection.DEFAULT_INSERT_OPTIONS);
    }

    public CompletableFuture<MutationResult> insert(String id, Object content, InsertOptions options) {
        Validators.notNull(options, "InsertOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        Validators.notNull(content, "Content", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        InsertOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.insertAsync(opts, id, () -> transcoder.encode(content), opts.toCoreDurability(), opts.expiry().encode()).toFuture().thenApply(MutationResult::new);
    }

    public CompletableFuture<MutationResult> upsert(String id, Object content) {
        return this.upsert(id, content, ReactiveCollection.DEFAULT_UPSERT_OPTIONS);
    }

    public CompletableFuture<MutationResult> upsert(String id, Object content, UpsertOptions options) {
        Validators.notNull(options, "UpsertOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        Validators.notNull(content, "Content", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        UpsertOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.upsertAsync(opts, id, () -> transcoder.encode(content), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry()).toFuture().thenApply(MutationResult::new);
    }

    public CompletableFuture<MutationResult> replace(String id, Object content) {
        return this.replace(id, content, ReactiveCollection.DEFAULT_REPLACE_OPTIONS);
    }

    public CompletableFuture<MutationResult> replace(String id, Object content, ReplaceOptions options) {
        Validators.notNull(options, "ReplaceOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        Validators.notNull(content, "Content", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        ReplaceOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return this.kvOps.replaceAsync(opts, id, () -> transcoder.encode(content), opts.cas(), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry()).toFuture().thenApply(MutationResult::new);
    }

    public CompletableFuture<MutationResult> touch(String id, Duration expiry) {
        return this.touch(id, expiry, ReactiveCollection.DEFAULT_TOUCH_OPTIONS);
    }

    public CompletableFuture<MutationResult> touch(String id, Duration expiry, TouchOptions options) {
        return this.touch(id, Expiry.relative(expiry), options);
    }

    public CompletableFuture<MutationResult> touch(String id, Instant expiry) {
        return this.touch(id, expiry, ReactiveCollection.DEFAULT_TOUCH_OPTIONS);
    }

    public CompletableFuture<MutationResult> touch(String id, Instant expiry, TouchOptions options) {
        return this.touch(id, Expiry.absolute(expiry), options);
    }

    private CompletableFuture<MutationResult> touch(String id, Expiry expiry, TouchOptions options) {
        Validators.notNull(options, "TouchOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        Validators.notNull(expiry, "Expiry", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        TouchOptions.Built opts = options.build();
        return this.kvOps.touchAsync(opts, id, expiry.encode()).toFuture().thenApply(MutationResult::new);
    }

    public CompletableFuture<Void> unlock(String id, long cas) {
        return this.unlock(id, cas, ReactiveCollection.DEFAULT_UNLOCK_OPTIONS);
    }

    public CompletableFuture<Void> unlock(String id, long cas, UnlockOptions options) {
        Validators.notNull(options, "UnlockOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        UnlockOptions.Built opts = options.build();
        return this.kvOps.unlockAsync(opts, id, cas).toFuture();
    }

    public CompletableFuture<LookupInResult> lookupIn(String id, List<LookupInSpec> specs) {
        return this.lookupIn(id, specs, ReactiveCollection.DEFAULT_LOOKUP_IN_OPTIONS);
    }

    public CompletableFuture<LookupInResult> lookupIn(String id, List<LookupInSpec> specs, LookupInOptions options) {
        Validators.notNull(options, "LookupInOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        Validators.notNull(specs, "LookupInSpecs", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        LookupInOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return this.kvOps.subdocGetAsync(opts, id, CbCollections.transform(specs, LookupInSpec::toCore), opts.accessDeleted()).thenApply(it -> new LookupInResult((CoreSubdocGetResult)it, serializer));
    }

    public CompletableFuture<List<CompletableFuture<LookupInReplicaResult>>> lookupInAllReplicas(String id, List<LookupInSpec> specs) {
        return this.lookupInAllReplicas(id, specs, ReactiveCollection.DEFAULT_LOOKUP_IN_ALL_REPLICA_OPTIONS);
    }

    public CompletableFuture<List<CompletableFuture<LookupInReplicaResult>>> lookupInAllReplicas(String id, List<LookupInSpec> specs, LookupInAllReplicasOptions options) {
        Validators.notNull(options, "LookupInAllReplicasOptions");
        LookupInAllReplicasOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return ReplicaHelper.lookupInAllReplicasAsync(this.core(), this.keyspace.toCollectionIdentifier(), id, CbCollections.transform(specs, LookupInSpec::toCore), opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), opts.parentSpan().orElse(null), response -> LookupInReplicaResult.from(response, serializer));
    }

    public CompletableFuture<LookupInReplicaResult> lookupInAnyReplica(String id, List<LookupInSpec> specs) {
        return this.lookupInAnyReplica(id, specs, ReactiveCollection.DEFAULT_LOOKUP_IN_ANY_REPLICA_OPTIONS);
    }

    public CompletableFuture<LookupInReplicaResult> lookupInAnyReplica(String id, List<LookupInSpec> specs, LookupInAnyReplicaOptions options) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        Validators.notNull(options, "LookupInAnyReplicaOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        LookupInAnyReplicaOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return ReplicaHelper.lookupInAnyReplicaAsync(this.core(), this.keyspace.toCollectionIdentifier(), id, CbCollections.transform(specs, LookupInSpec::toCore), opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), opts.parentSpan().orElse(null), response -> LookupInReplicaResult.from(response, serializer));
    }

    public CompletableFuture<MutateInResult> mutateIn(String id, List<MutateInSpec> specs) {
        return this.mutateIn(id, specs, ReactiveCollection.DEFAULT_MUTATE_IN_OPTIONS);
    }

    public CompletableFuture<MutateInResult> mutateIn(String id, List<MutateInSpec> specs, MutateInOptions options) {
        Validators.notNull(options, "MutateInOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        Validators.notNull(specs, "MutationSpecs", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier()));
        MutateInOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        return this.kvOps.subdocMutateAsync(opts, id, () -> CbCollections.transform(specs, it -> it.toCore(serializer)), opts.storeSemantics().toCore(), opts.cas(), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry(), opts.accessDeleted(), opts.createAsDeleted()).thenApply(it -> new MutateInResult((CoreSubdocMutateResult)it, serializer));
    }

    public CompletableFuture<List<ScanResult>> scan(ScanType scanType) {
        return this.scan(scanType, ScanOptions.scanOptions());
    }

    public CompletableFuture<List<ScanResult>> scan(ScanType scanType, ScanOptions options) {
        Validators.notNull(scanType, "ScanType", () -> ReducedKeyValueErrorContext.create(null, this.collectionIdentifier()));
        ScanOptions.Built opts = Validators.notNull(options, "ScanOptions", () -> ReducedKeyValueErrorContext.create(null, this.collectionIdentifier())).build();
        return this.kvOps.scanRequestReactive(scanType.build(), opts).map(r -> new ScanResult(opts.idsOnly(), r.key(), r.value(), r.flags(), r.cas(), Optional.ofNullable(r.expiry()), opts.transcoder() != null ? opts.transcoder() : this.environment().transcoder())).collectList().toFuture();
    }

    CollectionIdentifier collectionIdentifier() {
        return this.keyspace.toCollectionIdentifier();
    }
}

