/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.manager.CoreBucketAndScope;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreSearchRequest;
import com.couchbase.client.core.api.search.result.CoreSearchResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.context.ReducedAnalyticsErrorContext;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.error.context.ReducedSearchErrorContext;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.analytics.AnalyticsAccessor;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsResult;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.eventing.AsyncScopeEventingFunctionManager;
import com.couchbase.client.java.manager.search.AsyncScopeSearchIndexManager;
import com.couchbase.client.java.query.QueryAccessor;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.search.SearchOptions;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.SearchRequest;
import com.couchbase.client.java.search.result.SearchResult;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class AsyncScope {
    private final CoreCouchbaseOps couchbaseOps;
    private final String bucketName;
    private final String scopeName;
    private final ClusterEnvironment environment;
    final CoreQueryOps queryOps;
    final CoreQueryContext queryContext;
    private final Map<String, AsyncCollection> collectionCache = new ConcurrentHashMap<String, AsyncCollection>();
    final CoreSearchOps searchOps;
    private final AsyncCluster cluster;

    AsyncScope(String scopeName, String bucketName, CoreCouchbaseOps couchbaseOps, ClusterEnvironment environment, AsyncCluster cluster) {
        this.scopeName = Objects.requireNonNull(scopeName);
        this.bucketName = Objects.requireNonNull(bucketName);
        this.couchbaseOps = Objects.requireNonNull(couchbaseOps);
        this.environment = Objects.requireNonNull(environment);
        this.queryOps = couchbaseOps.queryOps();
        this.queryContext = CoreQueryContext.of(bucketName, scopeName);
        this.searchOps = couchbaseOps.searchOps(new CoreBucketAndScope(bucketName, this.name()));
        this.cluster = Objects.requireNonNull(cluster);
    }

    public String name() {
        return this.scopeName;
    }

    public String bucketName() {
        return this.bucketName;
    }

    @Stability.Volatile
    public Core core() {
        return this.couchbaseOps.asCore();
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    AsyncCollection defaultCollection() {
        return this.maybeCreateAsyncCollection("_default", !this.scopeName.equals("_default"));
    }

    public AsyncCollection collection(String collectionName) {
        boolean defaultScopeAndCollection = collectionName.equals("_default") && this.scopeName.equals("_default");
        return this.maybeCreateAsyncCollection(collectionName, !defaultScopeAndCollection);
    }

    private AsyncCollection maybeCreateAsyncCollection(String collectionName, boolean refreshMap) {
        return this.collectionCache.computeIfAbsent(collectionName, name -> {
            CoreKeyspace keyspace = new CoreKeyspace(this.bucketName, this.scopeName, collectionName);
            if (refreshMap && this.couchbaseOps instanceof Core) {
                ((Core)this.couchbaseOps).configurationProvider().refreshCollectionId(keyspace.toCollectionIdentifier());
            }
            return new AsyncCollection(keyspace, this.couchbaseOps, this.environment, this.cluster);
        });
    }

    public CompletableFuture<QueryResult> query(String statement) {
        return this.query(statement, ReactiveCluster.DEFAULT_QUERY_OPTIONS);
    }

    public CompletableFuture<QueryResult> query(String statement, QueryOptions options) {
        Validators.notNull(options, "QueryOptions", () -> new ReducedQueryErrorContext(statement));
        QueryOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return this.queryOps.queryAsync(statement, opts, this.queryContext, null, QueryAccessor::convertCoreQueryError).thenApply(r -> new QueryResult((CoreQueryResult)r, serializer));
    }

    public CompletableFuture<AnalyticsResult> analyticsQuery(String statement) {
        return this.analyticsQuery(statement, ReactiveCluster.DEFAULT_ANALYTICS_OPTIONS);
    }

    public CompletableFuture<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Validators.notNull(options, "AnalyticsOptions", () -> new ReducedAnalyticsErrorContext(statement));
        AnalyticsOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return AnalyticsAccessor.analyticsQueryAsync(this.core(), this.analyticsRequest(statement, opts), serializer);
    }

    AnalyticsRequest analyticsRequest(String statement, AnalyticsOptions.Built opts) {
        Validators.notNullOrEmpty(statement, "Statement", () -> new ReducedAnalyticsErrorContext(statement));
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().analyticsTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        JsonObject query = JsonObject.create();
        query.put("statement", statement);
        query.put("timeout", Golang.encodeDurationToMs(timeout));
        query.put("query_context", AnalyticsRequest.queryContext(this.bucketName, this.scopeName));
        opts.injectParams(query);
        byte[] queryBytes = query.toString().getBytes(StandardCharsets.UTF_8);
        String clientContextId = query.getString("client_context_id");
        RequestSpan span = this.environment().requestTracer().requestSpan("analytics", opts.parentSpan().orElse(null));
        AnalyticsRequest request = new AnalyticsRequest(timeout, this.core().context(), retryStrategy, this.core().context().authenticator(), queryBytes, opts.priority(), opts.readonly(), clientContextId, statement, span, this.bucketName, this.scopeName);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<SearchResult> search(String indexName, SearchRequest searchRequest) {
        return this.search(indexName, searchRequest, ReactiveCluster.DEFAULT_SEARCH_OPTIONS);
    }

    public CompletableFuture<SearchResult> search(String indexName, SearchRequest searchRequest, SearchOptions options) {
        Validators.notNull(searchRequest, "SearchRequest", () -> new ReducedSearchErrorContext(indexName, null));
        Validators.notNull(options, "SearchOptions", () -> new ReducedSearchErrorContext(indexName, null));
        CoreSearchRequest coreRequest = searchRequest.toCore();
        SearchOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return this.searchOps.searchAsync(indexName, coreRequest, opts).thenApply(r -> new SearchResult((CoreSearchResult)r, serializer));
    }

    public CompletableFuture<SearchResult> searchQuery(String indexName, SearchQuery query) {
        return this.searchQuery(indexName, query, ReactiveCluster.DEFAULT_SEARCH_OPTIONS);
    }

    @Stability.Volatile
    public CompletableFuture<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Validators.notNull(query, "SearchQuery", () -> new ReducedSearchErrorContext(indexName, null));
        CoreSearchQuery coreQuery = query.toCore();
        Validators.notNull(options, "SearchOptions", () -> new ReducedSearchErrorContext(indexName, coreQuery));
        SearchOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return this.searchOps.searchQueryAsync(indexName, coreQuery, opts).thenApply(r -> new SearchResult((CoreSearchResult)r, serializer));
    }

    public AsyncScopeSearchIndexManager searchIndexes() {
        return new AsyncScopeSearchIndexManager(this.couchbaseOps, this, this.cluster);
    }

    @Stability.Volatile
    public AsyncScopeEventingFunctionManager eventingFunctions() {
        return new AsyncScopeEventingFunctionManager(this.core(), this.cluster, new CoreBucketAndScope(this.bucketName, this.name()));
    }
}

