/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.api.kv.CoreKvBinaryOps;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncBinaryCollection;
import com.couchbase.client.java.kv.AppendOptions;
import com.couchbase.client.java.kv.CounterResult;
import com.couchbase.client.java.kv.DecrementOptions;
import com.couchbase.client.java.kv.IncrementOptions;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PrependOptions;
import java.util.Objects;

public class BinaryCollection {
    static final AppendOptions DEFAULT_APPEND_OPTIONS = AppendOptions.appendOptions();
    static final PrependOptions DEFAULT_PREPEND_OPTIONS = PrependOptions.prependOptions();
    static final IncrementOptions DEFAULT_INCREMENT_OPTIONS = IncrementOptions.incrementOptions();
    static final DecrementOptions DEFAULT_DECREMENT_OPTIONS = DecrementOptions.decrementOptions();
    private final CollectionIdentifier collectionIdentifier;
    private final CoreKvBinaryOps coreKvBinaryOps;
    private final AsyncBinaryCollection async;

    BinaryCollection(AsyncBinaryCollection asyncBinaryCollection) {
        this.collectionIdentifier = asyncBinaryCollection.collectionIdentifier();
        this.coreKvBinaryOps = asyncBinaryCollection.coreKvBinaryOps;
        this.async = Objects.requireNonNull(asyncBinaryCollection);
    }

    public MutationResult append(String id, byte[] content) {
        return this.append(id, content, DEFAULT_APPEND_OPTIONS);
    }

    public MutationResult append(String id, byte[] content, AppendOptions options) {
        AppendOptions.Built opts = Validators.notNull(options, "AppendOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier)).build();
        return new MutationResult(this.coreKvBinaryOps.appendBlocking(id, content, opts, opts.cas(), opts.toCoreDurability()));
    }

    public MutationResult prepend(String id, byte[] content) {
        return this.prepend(id, content, DEFAULT_PREPEND_OPTIONS);
    }

    public MutationResult prepend(String id, byte[] content, PrependOptions options) {
        PrependOptions.Built opts = Validators.notNull(options, "PrependOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier)).build();
        return new MutationResult(this.coreKvBinaryOps.prependBlocking(id, content, opts, opts.cas(), opts.toCoreDurability()));
    }

    public CounterResult increment(String id) {
        return this.increment(id, DEFAULT_INCREMENT_OPTIONS);
    }

    public CounterResult increment(String id, IncrementOptions options) {
        IncrementOptions.Built opts = Validators.notNull(options, "IncrementOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier)).build();
        return new CounterResult(this.coreKvBinaryOps.incrementBlocking(id, opts, opts.expiry().encode(), opts.delta(), opts.initial(), opts.toCoreDurability()));
    }

    public CounterResult decrement(String id) {
        return this.decrement(id, DEFAULT_DECREMENT_OPTIONS);
    }

    public CounterResult decrement(String id, DecrementOptions options) {
        DecrementOptions.Built opts = Validators.notNull(options, "DecrementOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier)).build();
        return new CounterResult(this.coreKvBinaryOps.decrementBlocking(id, opts, opts.expiry().encode(), opts.delta(), opts.initial(), opts.toCoreDurability()));
    }
}

