/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreLimiter;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.OwnedOrExternal;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.error.context.ReducedQueryErrorContext;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.core.util.ConnectionStringUtil;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsResult;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.diagnostics.DiagnosticsOptions;
import com.couchbase.client.java.diagnostics.PingOptions;
import com.couchbase.client.java.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.http.CouchbaseHttpClient;
import com.couchbase.client.java.manager.analytics.AnalyticsIndexManager;
import com.couchbase.client.java.manager.bucket.BucketManager;
import com.couchbase.client.java.manager.eventing.EventingFunctionManager;
import com.couchbase.client.java.manager.query.QueryIndexManager;
import com.couchbase.client.java.manager.search.SearchIndexManager;
import com.couchbase.client.java.manager.user.UserManager;
import com.couchbase.client.java.query.QueryAccessor;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.search.SearchOptions;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.SearchRequest;
import com.couchbase.client.java.search.result.SearchResult;
import com.couchbase.client.java.transactions.Transactions;
import java.io.Closeable;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Cluster
implements Closeable {
    private final AsyncCluster asyncCluster;
    private final ReactiveCluster reactiveCluster;
    private final Map<String, Bucket> bucketCache = new ConcurrentHashMap<String, Bucket>();

    public static Cluster connect(String connectionString, String username, String password) {
        return Cluster.connect(connectionString, ClusterOptions.clusterOptions(PasswordAuthenticator.create(username, password)));
    }

    public static Cluster connect(String connectionString, ClusterOptions options) {
        Validators.notNullOrEmpty(connectionString, "ConnectionString");
        Validators.notNull(options, "ClusterOptions");
        ConnectionString connStr = ConnectionString.create(connectionString);
        ClusterOptions.Built opts = options.build();
        OwnedOrExternal<ClusterEnvironment> environmentSupplier = AsyncCluster.extractClusterEnvironment(connStr, opts);
        return new Cluster(environmentSupplier, opts.authenticator(), connStr);
    }

    public static Cluster connect(Set<SeedNode> seedNodes, ClusterOptions options) {
        return Cluster.connect(ConnectionStringUtil.asConnectionString(seedNodes).original(), options);
    }

    @Stability.Uncommitted
    public static void maxAllowedInstances(int maxAllowedInstances) {
        CoreLimiter.setMaxAllowedInstances(maxAllowedInstances);
    }

    @Stability.Uncommitted
    public static void failIfInstanceLimitReached(boolean failIfInstanceLimitReached) {
        CoreLimiter.setFailIfInstanceLimitReached(failIfInstanceLimitReached);
    }

    private Cluster(OwnedOrExternal<ClusterEnvironment> environment, Authenticator authenticator, ConnectionString connectionString) {
        this.asyncCluster = new AsyncCluster(environment, authenticator, connectionString);
        this.reactiveCluster = new ReactiveCluster(this.asyncCluster);
    }

    public AsyncCluster async() {
        return this.asyncCluster;
    }

    public ReactiveCluster reactive() {
        return this.reactiveCluster;
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncCluster.core();
    }

    @Stability.Volatile
    public CouchbaseHttpClient httpClient() {
        return new CouchbaseHttpClient(this.asyncCluster.httpClient());
    }

    public UserManager users() {
        return new UserManager(this.asyncCluster.users());
    }

    public BucketManager buckets() {
        return new BucketManager(this.asyncCluster.buckets());
    }

    public AnalyticsIndexManager analyticsIndexes() {
        return new AnalyticsIndexManager(this);
    }

    public QueryIndexManager queryIndexes() {
        return new QueryIndexManager(this.asyncCluster.queryIndexes());
    }

    public SearchIndexManager searchIndexes() {
        return new SearchIndexManager(this.asyncCluster.searchIndexes());
    }

    @Stability.Uncommitted
    public EventingFunctionManager eventingFunctions() {
        return new EventingFunctionManager(this.asyncCluster.eventingFunctions());
    }

    public ClusterEnvironment environment() {
        return this.asyncCluster.environment();
    }

    public QueryResult query(String statement) {
        return this.query(statement, ReactiveCluster.DEFAULT_QUERY_OPTIONS);
    }

    public QueryResult query(String statement, QueryOptions options) {
        Validators.notNull(options, "QueryOptions", () -> new ReducedQueryErrorContext(statement));
        QueryOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        return new QueryResult(this.async().queryOps.queryBlocking(statement, opts, null, null, QueryAccessor::convertCoreQueryError), serializer);
    }

    public AnalyticsResult analyticsQuery(String statement) {
        return this.analyticsQuery(statement, ReactiveCluster.DEFAULT_ANALYTICS_OPTIONS);
    }

    public AnalyticsResult analyticsQuery(String statement, AnalyticsOptions options) {
        return AsyncUtils.block(this.async().analyticsQuery(statement, options));
    }

    public SearchResult search(String indexName, SearchRequest searchRequest) {
        return this.search(indexName, searchRequest, ReactiveCluster.DEFAULT_SEARCH_OPTIONS);
    }

    public SearchResult search(String indexName, SearchRequest searchRequest, SearchOptions options) {
        return AsyncUtils.block(this.asyncCluster.search(indexName, searchRequest, options));
    }

    public SearchResult searchQuery(String indexName, SearchQuery query) {
        return this.searchQuery(indexName, query, ReactiveCluster.DEFAULT_SEARCH_OPTIONS);
    }

    public SearchResult searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        return AsyncUtils.block(this.asyncCluster.searchQuery(indexName, query, options));
    }

    public Bucket bucket(String bucketName) {
        return this.bucketCache.computeIfAbsent(bucketName, n -> new Bucket(this.asyncCluster.bucket((String)n)));
    }

    public void disconnect() {
        AsyncUtils.block(this.asyncCluster.disconnect());
    }

    public void disconnect(Duration timeout) {
        AsyncUtils.block(this.asyncCluster.disconnect(timeout));
    }

    public DiagnosticsResult diagnostics() {
        return AsyncUtils.block(this.asyncCluster.diagnostics(ReactiveCluster.DEFAULT_DIAGNOSTICS_OPTIONS));
    }

    public DiagnosticsResult diagnostics(DiagnosticsOptions options) {
        return AsyncUtils.block(this.asyncCluster.diagnostics(options));
    }

    public PingResult ping() {
        return AsyncUtils.block(this.asyncCluster.ping());
    }

    public PingResult ping(PingOptions options) {
        return AsyncUtils.block(this.asyncCluster.ping(options));
    }

    public void waitUntilReady(Duration timeout) {
        AsyncUtils.block(this.asyncCluster.waitUntilReady(timeout));
    }

    public void waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        AsyncUtils.block(this.asyncCluster.waitUntilReady(timeout, options));
    }

    @Stability.Uncommitted
    public Transactions transactions() {
        return new Transactions(this.core(), this.environment().jsonSerializer());
    }

    @Override
    public void close() {
        this.disconnect();
    }
}

