/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.Transcoder;

public class RawBinaryTranscoder
implements Transcoder {
    public static RawBinaryTranscoder INSTANCE = new RawBinaryTranscoder();

    private RawBinaryTranscoder() {
    }

    @Override
    public Transcoder.EncodedValue encode(Object input) {
        if (input instanceof CommonOptions.BuiltCommonOptions || input instanceof CommonOptions) {
            throw InvalidArgumentException.fromMessage("No content provided, cannot encode " + input.getClass().getSimpleName() + " as content!");
        }
        if (input instanceof byte[]) {
            return new Transcoder.EncodedValue((byte[])input, CodecFlags.BINARY_COMPAT_FLAGS);
        }
        throw InvalidArgumentException.fromMessage("Only byte[] is supported for the RawBinaryTranscoder!");
    }

    @Override
    public <T> T decode(Class<T> target, byte[] input, int flags) {
        if (target.equals(byte[].class)) {
            return (T)input;
        }
        throw new DecodingFailureException("RawBinaryTranscoder can only decode into byte[]!");
    }
}

