/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.datastructures;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.error.subdoc.PathExistsException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.retry.reactor.RetryExhaustedException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonValue;
import com.couchbase.client.java.kv.ArraySetOptions;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.StoreSemantics;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

@Stability.Committed
public class CouchbaseArraySet<T>
extends AbstractSet<T> {
    private final String id;
    private final Collection collection;
    private ArraySetOptions.Built arraySetOptions;
    private final GetOptions getOptions;
    private final LookupInOptions lookupInOptions;

    public CouchbaseArraySet(String id, Collection collection, Class<T> entityType, ArraySetOptions options) {
        Validators.notNull(collection, "Collection", () -> ReducedKeyValueErrorContext.create(id, null, null, null));
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        Validators.notNull(entityType, "EntityType", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        Validators.notNull(options, "ArraySetOptions", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        this.id = id;
        this.collection = collection;
        ArraySetOptions.Built optionsIn = options.build();
        ArraySetOptions arrayOpts = ArraySetOptions.arraySetOptions();
        optionsIn.copyInto(arrayOpts);
        this.arraySetOptions = arrayOpts.build();
        this.getOptions = optionsIn.getOptions();
        this.lookupInOptions = optionsIn.lookupInOptions();
    }

    @Override
    public int size() {
        try {
            LookupInResult result = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.count("")), this.lookupInOptions);
            return result.contentAs(0, Integer.class);
        }
        catch (DocumentNotFoundException e) {
            return 0;
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            LookupInResult current = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.exists("[0]")), this.lookupInOptions);
            return !current.exists(0);
        }
        catch (DocumentNotFoundException e) {
            return true;
        }
    }

    @Override
    public boolean contains(Object t) {
        this.enforcePrimitive(t);
        try {
            GetResult result = this.collection.get(this.id, this.getOptions);
            JsonArray current = result.contentAs(JsonArray.class);
            for (Object in : current) {
                if (!this.safeEquals(in, t)) continue;
                return true;
            }
            return false;
        }
        catch (DocumentNotFoundException e) {
            return false;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new CouchbaseArraySetIterator();
    }

    @Override
    public boolean add(T t) {
        this.enforcePrimitive(t);
        try {
            this.collection.mutateIn(this.id, Collections.singletonList(MutateInSpec.arrayAddUnique("", t)), this.arraySetOptions.mutateInOptions().storeSemantics(StoreSemantics.UPSERT));
            return true;
        }
        catch (PathExistsException ex) {
            return false;
        }
    }

    @Override
    public boolean remove(Object t) {
        this.enforcePrimitive(t);
        for (int i = 0; i < this.arraySetOptions.casMismatchRetries(); ++i) {
            try {
                GetResult result = this.collection.get(this.id);
                JsonArray current = result.contentAsArray();
                long cas = result.cas();
                int index = 0;
                boolean found = false;
                for (Object next : current) {
                    if (this.safeEquals(next, t)) {
                        found = true;
                        break;
                    }
                    ++index;
                }
                String path = "[" + index + "]";
                if (!found) {
                    return false;
                }
                this.collection.mutateIn(this.id, Collections.singletonList(MutateInSpec.remove(path)), this.arraySetOptions.mutateInOptions().cas(cas));
                return true;
            }
            catch (CasMismatchException result) {
                continue;
            }
            catch (DocumentNotFoundException ex) {
                return false;
            }
        }
        throw new CouchbaseException("CouchbaseArraySet remove failed", new RetryExhaustedException("Couldn't perform remove in less than " + this.arraySetOptions.casMismatchRetries() + " iterations. It is likely concurrent modifications of this document are the reason"));
    }

    @Override
    public void clear() {
        this.collection.remove(this.id);
    }

    private void enforcePrimitive(Object t) throws ClassCastException {
        if (!JsonValue.checkType(t) || t instanceof JsonValue) {
            throw new ClassCastException("Only primitive types are supported in CouchbaseArraySet, got a " + t.getClass().getName());
        }
    }

    private boolean safeEquals(Object expected, Object tested) {
        if (expected == null) {
            return tested == null;
        }
        return expected.equals(tested);
    }

    private class CouchbaseArraySetIterator<E>
    implements Iterator<E> {
        private long cas;
        private final Iterator<E> delegate;
        private int lastVisited;
        private int cursor;

        CouchbaseArraySetIterator() {
            JsonArray current;
            try {
                GetResult result = CouchbaseArraySet.this.collection.get(CouchbaseArraySet.this.id);
                current = result.contentAs(JsonArray.class);
                this.cas = result.cas();
            }
            catch (DocumentNotFoundException e) {
                current = JsonArray.create();
                this.cas = 0L;
            }
            ArrayList list = new ArrayList(current.size());
            for (Object value : current) {
                list.add(value);
            }
            this.delegate = list.iterator();
            this.lastVisited = -1;
            this.cursor = 0;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            E next = this.delegate.next();
            this.lastVisited = this.cursor++;
            return next;
        }

        @Override
        public void remove() {
            if (this.lastVisited < 0) {
                throw new IllegalStateException();
            }
            int index = this.lastVisited;
            String idx = "[" + index + "]";
            try {
                MutateInResult updated = CouchbaseArraySet.this.collection.mutateIn(CouchbaseArraySet.this.id, Collections.singletonList(MutateInSpec.remove(idx)), CouchbaseArraySet.this.arraySetOptions.mutateInOptions().cas(this.cas));
                this.cas = updated.cas();
                this.delegate.remove();
                this.cursor = this.lastVisited;
                this.lastVisited = -1;
            }
            catch (CasMismatchException | DocumentNotFoundException ex) {
                throw new ConcurrentModificationException("List was modified since iterator creation: " + ex);
            }
            catch (PathNotFoundException ex) {
                throw new ConcurrentModificationException("Element doesn't exist anymore at index: " + index);
            }
        }
    }
}

